/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import com.fasterxml.jackson.core.JsonParseException;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.List;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.ArgumentUtil;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.util.JsonUtil;

public abstract class AbstractSendTransport
extends SimpleChannelInboundHandler<FullHttpRequest> {
    protected final SockJsConfig config;

    protected AbstractSendTransport(SockJsConfig config) {
        ArgumentUtil.checkNotNull(config, "config");
        this.config = config;
    }

    public void messageReceived(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        String content = AbstractSendTransport.getContent(request);
        if (content.isEmpty()) {
            ctx.writeAndFlush((Object)Transports.internalServerErrorResponse(request.getProtocolVersion(), "Payload expected.")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            try {
                String[] messages;
                for (String message : messages = JsonUtil.decode(content)) {
                    ctx.fireChannelRead((Object)message);
                }
                this.respond(ctx, request);
            }
            catch (JsonParseException e) {
                ctx.writeAndFlush((Object)Transports.internalServerErrorResponse(request.getProtocolVersion(), "Broken JSON encoding."));
            }
        }
    }

    public abstract void respond(ChannelHandlerContext var1, FullHttpRequest var2) throws Exception;

    private static String getContent(FullHttpRequest request) {
        String contentType = AbstractSendTransport.getContentType(request);
        if ("application/x-www-form-urlencoded".equals(contentType)) {
            List<String> data = AbstractSendTransport.getDataFormParameter(request);
            if (data != null) {
                return data.get(0);
            }
            return "";
        }
        return request.content().toString(CharsetUtil.UTF_8);
    }

    private static String getContentType(FullHttpRequest request) {
        String contentType = request.headers().get(HttpHeaders.Names.CONTENT_TYPE);
        if (contentType == null) {
            return "text/plain; charset=UTF-8";
        }
        return contentType;
    }

    private static List<String> getDataFormParameter(FullHttpRequest request) {
        QueryStringDecoder decoder = new QueryStringDecoder('?' + request.content().toString(CharsetUtil.UTF_8));
        return (List)decoder.parameters().get("d");
    }

    protected void respond(ChannelHandlerContext ctx, HttpVersion httpVersion, HttpResponseStatus status, String message) {
        FullHttpResponse response = Transports.responseWithContent(httpVersion, status, "text/plain; charset=UTF-8", message);
        Transports.setDefaultHeaders((HttpResponse)response, this.config);
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

