/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.AbstractSendTransport;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class JsonpSendTransport
extends AbstractSendTransport {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JsonpSendTransport.class);

    public JsonpSendTransport(SockJsConfig config) {
        super(config);
    }

    @Override
    public void respond(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        FullHttpResponse response = Transports.responseWithContent(request.getProtocolVersion(), HttpResponseStatus.OK, "text/plain; charset=UTF-8", "ok");
        logger.info("Responding=" + response.getStatus() + ", request.uri=" + request.getUri());
        Transports.setDefaultHeaders((HttpResponse)response, this.config);
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)((Object)this)) + "[config=" + this.config + ']';
    }
}

