/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.CloseFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.PreludeFrame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class XhrStreamingTransport
extends ChannelHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(XhrStreamingTransport.class);
    private final AtomicBoolean headerSent = new AtomicBoolean(false);
    private final AtomicInteger bytesSent = new AtomicInteger(0);
    private final SockJsConfig config;
    private final HttpRequest request;

    public XhrStreamingTransport(SockJsConfig config, HttpRequest request) {
        this.config = config;
        this.request = request;
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            Frame frame = (Frame)msg;
            if (this.headerSent.compareAndSet(false, true)) {
                HttpResponse response = this.createResponse("application/javascript; charset=UTF-8");
                ctx.writeAndFlush((Object)response);
                ByteBuf content = Transports.wrapWithLN(new PreludeFrame().content());
                DefaultHttpContent preludeChunk = new DefaultHttpContent(content);
                ctx.writeAndFlush((Object)preludeChunk);
            }
            ctx.writeAndFlush((Object)new DefaultHttpContent(Transports.wrapWithLN(frame.content())), promise);
            if (frame instanceof CloseFrame) {
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            if (this.maxBytesLimit(frame.content().readableBytes())) {
                logger.debug("max bytesSize limit reached [{}]", (Object)this.config.maxStreamingBytesSize());
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
            frame.release();
        } else {
            ctx.writeAndFlush(ReferenceCountUtil.retain((Object)msg), promise);
        }
    }

    private boolean maxBytesLimit(int bytesWritten) {
        this.bytesSent.addAndGet(bytesWritten);
        return this.bytesSent.get() >= this.config.maxStreamingBytesSize();
    }

    protected HttpResponse createResponse(String contentType) {
        HttpVersion version = this.request.getProtocolVersion();
        DefaultHttpResponse response = new DefaultHttpResponse(version, HttpResponseStatus.OK);
        if (this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            response.headers().set(HttpHeaders.Names.TRANSFER_ENCODING, (Object)HttpHeaders.Values.CHUNKED);
        }
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)contentType);
        Transports.setDefaultHeaders((HttpResponse)response, this.config);
        return response;
    }
}

