/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.util;

import java.util.Collection;

public final class ArgumentUtil {
    private ArgumentUtil() {
    }

    public static <T> void checkNotNull(T ref, String name) {
        if (ref == null) {
            throw new NullPointerException('[' + name + "] must not be null");
        }
    }

    public static <T> void checkNotNullAndNotEmpty(T ref, String name) {
        ArgumentUtil.checkNotNull(ref, name);
        if ("".equals(ref)) {
            throw new IllegalArgumentException('[' + name + "] must not be empty");
        }
    }

    public static void checkNotNullAndNotEmpty(Collection<?> c, String name) {
        ArgumentUtil.checkNotNull(c, name);
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Collection[" + name + "] must not be empty");
        }
    }

    public static void checkNotEmpty(Collection<?> c, String name) {
        if (c.isEmpty()) {
            throw new IllegalArgumentException("Collection[" + name + "] must not be empty");
        }
    }

    public static void checkNotNegative(long value, String name) {
        if (value < 0L) {
            throw new IllegalArgumentException('[' + name + "] must not be a negative number");
        }
    }
}

