/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.auth;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.AuthenticationManager;
import org.jboss.aerogear.security.auth.CredentialFactory;
import org.jboss.aerogear.security.exception.AeroGearSecurityException;
import org.jboss.aerogear.security.exception.HttpStatus;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.picketbox.cdi.PicketBoxIdentity;

@ApplicationScoped
public class AuthenticationManagerImpl
implements AuthenticationManager {
    @Inject
    private PicketBoxIdentity identity;
    @Inject
    private CredentialFactory credentialFactory;

    public void login(AeroGearUser aeroGearUser) {
        this.credentialFactory.setCredential(aeroGearUser);
        this.identity.login();
        this.onAuthenticationFailure();
    }

    public void logout() {
        this.onAuthenticationFailure();
        this.identity.logout();
    }

    private void onAuthenticationFailure() {
        if (!this.identity.isLoggedIn()) {
            throw new AeroGearSecurityException(HttpStatus.AUTHENTICATION_FAILED);
        }
    }
}

