/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.authz;

import java.util.ArrayList;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.model.AeroGearUser;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

@ApplicationScoped
public class GrantConfiguration
implements IdentityManagement.GrantMethods {
    private static final String USERS_GROUP = "Default Users Group";
    @Inject
    private IdentityManager identityManager;
    private List<Role> list;

    public GrantConfiguration roles(String[] roles) {
        this.list = new ArrayList<Role>();
        for (String role : roles) {
            Role newRole = this.identityManager.createRole(role);
            this.list.add(newRole);
        }
        return this;
    }

    public void to(AeroGearUser aeroGearUser) {
        User picketLinkUser = this.identityManager.createUser(aeroGearUser.getId());
        picketLinkUser.setEmail(aeroGearUser.getEmail());
        picketLinkUser.setFirstName(aeroGearUser.getFirstName());
        picketLinkUser.setLastName(aeroGearUser.getLastName());
        Group usersGroup = this.identityManager.createGroup(USERS_GROUP);
        this.identityManager.updateCredential(picketLinkUser, (Credential)new PasswordCredential(aeroGearUser.getPassword()));
        for (Role role : this.list) {
            this.identityManager.grantRole(role, (IdentityType)picketLinkUser, usersGroup);
        }
    }
}

