/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketbox.config;

import javax.annotation.PostConstruct;
import javax.ejb.Singleton;
import javax.ejb.Startup;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import org.picketbox.core.identity.impl.JPAIdentityStoreContext;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Credential;
import org.picketlink.idm.credential.PasswordCredential;
import org.picketlink.idm.model.Group;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;

@Singleton
@Startup
public class PicketBoxLoadUsers {
    @PersistenceContext(type=PersistenceContextType.EXTENDED)
    private EntityManager entityManager;
    @Inject
    private IdentityManager identityManager;

    @PostConstruct
    public void create() {
        JPAIdentityStoreContext.set((EntityManager)this.entityManager);
        User user = this.identityManager.createUser("john");
        user.setEmail("john@doe.com");
        user.setFirstName("John");
        user.setLastName("Doe");
        this.identityManager.updateCredential(user, (Credential)new PasswordCredential("123"));
        Role roleDeveloper = this.identityManager.createRole("simple");
        Role roleAdmin = this.identityManager.createRole("admin");
        Group groupCoreDeveloper = this.identityManager.createGroup("Core Developers");
        this.identityManager.grantRole(roleDeveloper, (IdentityType)user, groupCoreDeveloper);
        this.identityManager.grantRole(roleAdmin, (IdentityType)user, groupCoreDeveloper);
        JPAIdentityStoreContext.clear();
    }
}

