/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.picketlink.authz;

import java.io.Serializable;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.aerogear.security.auth.LoggedUser;
import org.jboss.aerogear.security.auth.Secret;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.otp.api.Base32;
import org.jboss.aerogear.security.picketlink.authz.GrantConfiguration;
import org.picketlink.Identity;
import org.picketlink.idm.IdentityManager;
import org.picketlink.idm.credential.Password;
import org.picketlink.idm.model.Agent;
import org.picketlink.idm.model.Attribute;
import org.picketlink.idm.model.IdentityType;
import org.picketlink.idm.model.Role;
import org.picketlink.idm.model.User;
import org.picketlink.idm.query.IdentityQuery;

@ApplicationScoped
public class IdentityManagementImpl
implements IdentityManagement<User> {
    private static final String IDM_SECRET_ATTRIBUTE = "serial";
    @Inject
    private IdentityManager identityManager;
    @Inject
    private GrantConfiguration grantConfiguration;
    @Inject
    private Identity identity;

    public IdentityManagement.GrantMethods grant(String ... roles) {
        return this.grantConfiguration.roles(roles);
    }

    public User findByUsername(String username) throws RuntimeException {
        User user = this.identityManager.getUser(username);
        if (user == null) {
            throw new RuntimeException("User do not exist");
        }
        return user;
    }

    public void remove(String username) {
        if (this.isLoggedIn(username)) {
            throw new RuntimeException("User is logged in");
        }
        this.identityManager.remove((IdentityType)this.identityManager.getUser(username));
    }

    public void create(User user, String password) {
        this.identityManager.add((IdentityType)user);
        this.identityManager.updateCredential((Agent)user, (Object)new Password(password));
    }

    @Produces
    @Secret
    public String getSecret() {
        User user = (User)this.identity.getAgent();
        Attribute secret = user.getAttribute(IDM_SECRET_ATTRIBUTE);
        if (secret == null) {
            secret = new Attribute(IDM_SECRET_ATTRIBUTE, (Serializable)((Object)Base32.random()));
            user.setAttribute(secret);
            this.identityManager.update((IdentityType)user);
        }
        return (String)((Object)secret.getValue());
    }

    @Produces
    @LoggedUser
    public String getLogin() {
        String id = null;
        if (this.identity.isLoggedIn()) {
            id = this.identity.getAgent().getLoginName();
        }
        return id;
    }

    public boolean hasRoles(Set<String> roles) {
        if (this.identity.isLoggedIn()) {
            for (String role : roles) {
                if (!this.identityManager.hasRole((IdentityType)this.identity.getAgent(), this.identityManager.getRole(role))) continue;
                return true;
            }
        }
        return false;
    }

    public User findById(long id) throws RuntimeException {
        IdentityQuery query = this.identityManager.createIdentityQuery(User.class);
        query.setParameter(User.ID, new Object[]{id});
        return (User)query.getResultList().get(0);
    }

    public List<User> findAllByRole(String name) {
        Role role = this.identityManager.getRole(name);
        IdentityQuery query = this.identityManager.createIdentityQuery(User.class);
        query.setParameter(User.HAS_ROLE, new Object[]{role});
        return query.getResultList();
    }

    private boolean isLoggedIn(String username) {
        return this.identity.isLoggedIn() && this.identity.getAgent().getLoginName().equals(username);
    }
}

