/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.exception;

import com.wealdtech.DataError;
import com.wealdtech.ServerError;
import java.io.IOException;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.Response;

public class ExceptionHandler {
    private static final Logger LOGGER = Logger.getLogger(ExceptionHandler.class.getSimpleName());

    public static void handle(HttpServletResponse response, Exception exception) {
        Throwable e = exception.getCause();
        try {
            if (e instanceof DataError) {
                LOGGER.info("Error: " + e.getMessage());
                response.sendError(Response.Status.UNAUTHORIZED.getStatusCode());
            } else if (e instanceof ServerError) {
                LOGGER.info("Error: " + e.getMessage());
                response.sendError(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }
}

