/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.web.authz;

import com.google.common.collect.ImmutableMap;
import com.google.common.io.CharStreams;
import com.wealdtech.hawk.Hawk;
import com.wealdtech.hawk.HawkCredentials;
import com.wealdtech.hawk.HawkServer;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jboss.aerogear.security.auth.HawkCredentialProvider;

public class HawkAuthenticator {
    private static final String SERVER_AUTHORIZATION = "Server-Authorization";
    private static final String HOST = "Host";
    private static final String ENCODING = "UTF-8";
    private static final String AUTHORIZATION = "Authorization";
    private static final String CONTENT_LENGTH = "Content-Length";
    private static final String CALCULATED_HASH = "hash";
    private HawkServer server = new HawkServer.Builder().configuration(null).build();
    @Inject
    private HawkCredentialProvider credentialProvider;

    public void authenticate(HttpServletRequest request, HttpServletResponse response) throws ServletException {
        String hash = null;
        try {
            URI uri = this.getUri(request);
            ImmutableMap authorizationHeaders = this.server.splitAuthorizationHeader(request.getHeader(AUTHORIZATION));
            HawkCredentials credentials = this.credentialProvider.findByKey((String)authorizationHeaders.get((Object)"id"));
            if (authorizationHeaders.get((Object)CALCULATED_HASH) != null) {
                hash = Hawk.calculateMac((HawkCredentials)credentials, (String)CharStreams.toString((Readable)new InputStreamReader((InputStream)request.getInputStream(), ENCODING)));
            }
            this.server.authenticate(credentials, uri, request.getMethod(), authorizationHeaders, hash, this.hasBody(request));
            this.addAuthenticateHeader(response);
        }
        catch (Throwable de) {
            throw new ServletException(de);
        }
    }

    private boolean hasBody(HttpServletRequest request) {
        return request.getHeader(CONTENT_LENGTH) != null;
    }

    private URI getUri(HttpServletRequest request) throws ServletException {
        URI uri;
        try {
            uri = new URI(request.getScheme() + "://" + request.getHeader(HOST) + request.getRequestURI());
        }
        catch (URISyntaxException use) {
            throw new ServletException((Throwable)use);
        }
        return uri;
    }

    private void addAuthenticateHeader(HttpServletResponse response) {
        String authenticate = this.server.generateAuthenticateHeader();
        ArrayList<String> header = new ArrayList<String>();
        header.add(authenticate);
        response.addHeader(SERVER_AUTHORIZATION, ((Object)header).toString());
    }
}

