/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.interceptor;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import javax.interceptor.InvocationContext;
import org.jboss.aerogear.security.authz.IdentityManagement;
import org.jboss.aerogear.security.authz.Secure;
import org.jboss.resteasy.spi.UnauthorizedException;

@Interceptor
@Secure(value={})
public class SecurityInterceptor {
    @Inject
    private IdentityManagement<?> identityManagement;

    @AroundInvoke
    public Object invoke(InvocationContext ctx) throws Exception {
        Method method;
        Class<?> clazz = ctx.getTarget().getClass();
        if (clazz.isAnnotationPresent(Secure.class)) {
            this.authorize(this.clazzMetadata(ctx));
        }
        if ((method = ctx.getMethod()).isAnnotationPresent(Secure.class)) {
            this.authorize(this.methodMetadata(ctx));
        }
        return ctx.proceed();
    }

    private Set<String> clazzMetadata(InvocationContext ctx) {
        Secure annotation = ctx.getTarget().getClass().getAnnotation(Secure.class);
        return new HashSet<String>(Arrays.asList(annotation.value()));
    }

    private Set<String> methodMetadata(InvocationContext ctx) {
        Secure annotation = ctx.getMethod().getAnnotation(Secure.class);
        return new HashSet<String>(Arrays.asList(annotation.value()));
    }

    private void authorize(Set<String> roles) {
        boolean hasRoles = this.identityManagement.hasRoles(roles);
        if (!hasRoles) {
            throw new UnauthorizedException("Not authorized!");
        }
    }
}

