/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.security.web.filter;

import javax.servlet.FilterConfig;

public class SecureHeadersConfig {
    private final Long maxAge;
    private final Boolean includeSubDomains;
    private final String location;
    private String frameOptions;

    public SecureHeadersConfig(FilterConfig config) {
        this.maxAge = Long.valueOf(config.getInitParameter("max-age"));
        this.includeSubDomains = Boolean.valueOf(config.getInitParameter("include-subdomains"));
        this.location = config.getInitParameter("Location");
        this.frameOptions = config.getInitParameter("x-frame-options");
    }

    public String getMaxAge() {
        String header = "max-age=" + this.maxAge;
        if (this.includeSubDomains.booleanValue()) {
            header = header + "; includeSubdomains";
        }
        return header;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameOptions() {
        return this.frameOptions;
    }

    public boolean hasMaxAge() {
        return this.maxAge != null && this.maxAge >= 0L;
    }

    public boolean hasLocation() {
        return this.isEmpty(this.location);
    }

    public boolean hasFrameOptions() {
        return this.isEmpty(this.frameOptions);
    }

    private boolean isEmpty(String value) {
        return value != null && !value.trim().isEmpty();
    }
}

