/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.concurrent.EventExecutorGroup;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsServiceFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsInboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsOutboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsHandler;
import org.jboss.aerogear.simplepush.server.DefaultSimplePushServer;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.netty.NotificationHandler;
import org.jboss.aerogear.simplepush.server.netty.SimplePushServiceFactory;
import org.jboss.aerogear.simplepush.server.netty.UserAgentReaperHandler;
import org.jboss.aerogear.simplepush.server.netty.WebSocketSslServerSslContext;

public class SockJSChannelInitializer
extends ChannelInitializer<SocketChannel> {
    private final DataStore datastore;
    private final SimplePushServerConfig simplePushConfig;
    private final EventExecutorGroup backgroundGroup;
    private final SockJsConfig sockjsConfig;
    private final byte[] privateKey;
    private SSLContext sslContext;

    public SockJSChannelInitializer(SimplePushServerConfig simplePushConfig, DataStore datastore, SockJsConfig sockjsConfig, EventExecutorGroup backgroundGroup) {
        this.simplePushConfig = simplePushConfig;
        this.datastore = datastore;
        this.sockjsConfig = sockjsConfig;
        this.backgroundGroup = backgroundGroup;
        this.privateKey = DefaultSimplePushServer.generateAndStorePrivateKey((DataStore)datastore, (SimplePushServerConfig)simplePushConfig);
        if (sockjsConfig.isTls()) {
            this.sslContext = new WebSocketSslServerSslContext(sockjsConfig).sslContext();
        }
    }

    protected void initChannel(SocketChannel socketChannel) throws Exception {
        ChannelPipeline pipeline = socketChannel.pipeline();
        if (this.sockjsConfig.isTls()) {
            SSLEngine engine = this.sslContext.createSSLEngine();
            engine.setUseClientMode(false);
            pipeline.addLast(new ChannelHandler[]{new SslHandler(engine)});
        }
        pipeline.addLast(new ChannelHandler[]{new HttpServerCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(65536)});
        DefaultSimplePushServer simplePushServer = new DefaultSimplePushServer(this.datastore, this.simplePushConfig, this.privateKey);
        pipeline.addLast(new ChannelHandler[]{new NotificationHandler((SimplePushServer)simplePushServer)});
        pipeline.addLast(new ChannelHandler[]{new CorsInboundHandler()});
        pipeline.addLast(new ChannelHandler[]{new SockJsHandler(new SockJsServiceFactory[]{new SimplePushServiceFactory(this.sockjsConfig, (SimplePushServer)simplePushServer)})});
        pipeline.addLast(this.backgroundGroup, new ChannelHandler[]{new UserAgentReaperHandler((SimplePushServer)simplePushServer)});
        pipeline.addLast(new ChannelHandler[]{new CorsOutboundHandler()});
    }
}

