/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.netty.UserAgentReaper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class UserAgentReaperHandler
extends ChannelHandlerAdapter {
    private final Logger logger = LoggerFactory.getLogger(UserAgentReaperHandler.class);
    private final SimplePushServer simplePushServer;
    private static ScheduledFuture<?> scheduleFuture;
    private static final AtomicBoolean reaperStarted;

    public UserAgentReaperHandler(SimplePushServer simplePushServer) {
        this.simplePushServer = simplePushServer;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (this.started()) {
            return;
        }
        SimplePushServerConfig config = this.simplePushServer.config();
        this.logger.info("Creating UserAgentReaper job : " + config.userAgentReaperTimeout());
        scheduleFuture = ctx.executor().scheduleAtFixedRate((Runnable)new UserAgentReaper(this.simplePushServer), config.userAgentReaperTimeout(), config.userAgentReaperTimeout(), TimeUnit.MILLISECONDS);
        reaperStarted.set(true);
    }

    public boolean started() {
        return reaperStarted.get();
    }

    public void cancelReaper() {
        if (scheduleFuture != null && scheduleFuture.cancel(true)) {
            reaperStarted.set(false);
        }
    }

    static {
        reaperStarted = new AtomicBoolean(false);
    }
}

