/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.simplepush.server.netty.UserAgent;

public class UserAgents {
    private static final ConcurrentMap<String, UserAgent<SockJsSessionContext>> userAgents = new ConcurrentHashMap<String, UserAgent<SockJsSessionContext>>();
    private static final UserAgents INSTANCE = new UserAgents();

    private UserAgents() {
    }

    public static UserAgents getInstance() {
        return INSTANCE;
    }

    public void add(String uaid, SockJsSessionContext session) {
        userAgents.put(uaid, new UserAgent<SockJsSessionContext>(uaid, session, System.currentTimeMillis()));
    }

    public UserAgent<SockJsSessionContext> get(String uaid) {
        UserAgent userAgent = (UserAgent)userAgents.get(uaid);
        if (userAgent == null) {
            throw new IllegalStateException("Cound not find UserAgent [" + uaid.toString() + "]");
        }
        return userAgent;
    }

    public Collection<UserAgent<SockJsSessionContext>> all() {
        return userAgents.values();
    }

    public boolean contains(String uaid) {
        return userAgents.containsKey(uaid);
    }

    public void updateAccessedTime(String uaid) {
        if (uaid != null) {
            UserAgent userAgent = (UserAgent)userAgents.get(uaid);
            userAgent.timestamp(System.currentTimeMillis());
        }
    }
}

