/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.simplepush.server.netty.SimplePushSockJSService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebSocketSslServerSslContext {
    private static final String PROTOCOL = "TLS";
    private final SockJsConfig sockJsConfig;
    private final Logger logger = LoggerFactory.getLogger(SimplePushSockJSService.class);

    WebSocketSslServerSslContext(SockJsConfig sockJsConfig) {
        this.sockJsConfig = sockJsConfig;
    }

    public SSLContext sslContext() {
        try {
            SSLContext serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(this.keyManagerFactory(this.loadKeyStore()).getKeyManagers(), null, null);
            return serverContext;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to initialize the server-side SSLContext", e);
        }
    }

    private KeyManagerFactory keyManagerFactory(KeyStore ks) throws Exception {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance(this.getKeyManagerAlgorithm());
        kmf.init(ks, this.sockJsConfig.keyStorePassword().toCharArray());
        return kmf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyStore loadKeyStore() throws Exception {
        InputStream fin = null;
        try {
            fin = this.getClass().getResourceAsStream(this.sockJsConfig.keyStore());
            if (fin == null) {
                throw new IllegalStateException("Could not locate keystore [" + this.sockJsConfig.keyStore() + "]");
            }
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(fin, this.sockJsConfig.keyStorePassword().toCharArray());
            KeyStore keyStore = ks;
            this.safeClose(fin);
            return keyStore;
        }
        catch (Throwable throwable) {
            this.safeClose(fin);
            throw throwable;
        }
    }

    private String getKeyManagerAlgorithm() {
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        return algorithm;
    }

    private void safeClose(Closeable c) {
        try {
            if (c != null) {
                c.close();
            }
        }
        catch (IOException e) {
            this.logger.error("Error while trying to close closable [" + c + "]", (Throwable)e);
        }
    }
}

