/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty.standalone;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.simplepush.server.DefaultSimplePushConfig;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.datastore.CouchDBDataStore;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.datastore.InMemoryDataStore;
import org.jboss.aerogear.simplepush.server.datastore.JpaDataStore;
import org.jboss.aerogear.simplepush.server.datastore.RedisDataStore;
import org.jboss.aerogear.simplepush.server.netty.standalone.StandaloneConfig;

public class ConfigReader {
    private static final ObjectMapper OM = new ObjectMapper();

    private ConfigReader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static StandaloneConfig parse(String fileName) throws Exception {
        File configFile = new File(fileName);
        InputStream in = null;
        try {
            in = configFile.exists() ? new FileInputStream(configFile) : ConfigReader.class.getResourceAsStream(fileName);
            StandaloneConfig standaloneConfig = ConfigReader.parse(in);
            return standaloneConfig;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static StandaloneConfig parse(InputStream in) {
        try {
            JsonNode json = OM.readTree(in);
            return new StandaloneConfig(ConfigReader.parseSimplePushProperties(json), ConfigReader.parseSockJsProperties(json), ConfigReader.createDataStore(json));
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static DataStore createDataStore(JsonNode json) {
        JsonNode dataStore = json.get("datastore");
        if (dataStore == null) {
            throw new IllegalArgumentException("datastore element must be specified");
        }
        JsonNode inMemory = dataStore.get("in-memory");
        if (inMemory != null) {
            return new InMemoryDataStore();
        }
        JsonNode redis = dataStore.get("redis");
        if (redis != null) {
            return new RedisDataStore(redis.get("host").asText(), redis.get("port").asInt());
        }
        JsonNode couchdb = dataStore.get("couchdb");
        if (couchdb != null) {
            return new CouchDBDataStore(couchdb.get("url").asText(), couchdb.get("dbName").asText());
        }
        JsonNode jpa = dataStore.get("jpa");
        if (jpa != null) {
            return new JpaDataStore(jpa.get("persistenceUnit").asText());
        }
        throw new IllegalStateException("datastore must be specified");
    }

    private static SockJsConfig parseSockJsProperties(JsonNode json) {
        JsonNode websocketProtocols;
        JsonNode websocketHeartbeatInterval;
        JsonNode websocketEnable;
        JsonNode tls;
        JsonNode keystorePassword;
        JsonNode keystore;
        JsonNode maxStreamingBytesSize;
        JsonNode heartbeatInterval;
        JsonNode sessionTimeout;
        JsonNode sockjsUrl;
        JsonNode prefixNode = json.get("sockjs-prefix");
        String prefix = prefixNode != null ? prefixNode.asText() : "/simplepush";
        SockJsConfig.Builder builder = SockJsConfig.withPrefix((String)prefix);
        JsonNode cookiesNeeded = json.get("sockjs-cookies-needed");
        if (cookiesNeeded != null && cookiesNeeded.asBoolean()) {
            builder.cookiesNeeded();
        }
        if ((sockjsUrl = json.get("sockjs-url")) != null) {
            builder.sockJsUrl(sockjsUrl.asText());
        }
        if ((sessionTimeout = json.get("sockjs-session-timeout")) != null) {
            builder.sessionTimeout(sessionTimeout.asLong());
        }
        if ((heartbeatInterval = json.get("sockjs-heartbeat-interval")) != null) {
            builder.heartbeatInterval(heartbeatInterval.asLong());
        }
        if ((maxStreamingBytesSize = json.get("sockjs-max-streaming-bytes-size")) != null) {
            builder.maxStreamingBytesSize(maxStreamingBytesSize.asInt());
        }
        if ((keystore = json.get("sockjs-keystore")) != null) {
            builder.keyStore(keystore.asText());
        }
        if ((keystorePassword = json.get("sockjs-keystore-password")) != null) {
            builder.keyStorePassword(keystorePassword.asText());
        }
        if ((tls = json.get("sockjs-tls")) != null) {
            builder.tls(tls.asBoolean());
        }
        if ((websocketEnable = json.get("sockjs-websocket-enable")) != null && !websocketEnable.asBoolean()) {
            builder.disableWebSocket();
        }
        if ((websocketHeartbeatInterval = json.get("sockjs-websocket-heartbeat-interval")) != null) {
            builder.webSocketHeartbeatInterval(websocketHeartbeatInterval.asLong());
        }
        if ((websocketProtocols = json.get("sockjs-websocket-protocols")) != null) {
            builder.webSocketProtocols(websocketProtocols.asText().split(","));
        }
        return builder.build();
    }

    private static SimplePushServerConfig parseSimplePushProperties(JsonNode json) {
        JsonNode notifierMaxThreads;
        JsonNode ackInterval;
        JsonNode endpointPrefix;
        JsonNode endpointTls;
        JsonNode endpointPort;
        JsonNode endpointHost;
        JsonNode useragentReaperTimeout;
        JsonNode host = json.get("host");
        JsonNode port = json.get("port");
        DefaultSimplePushConfig.Builder builder = DefaultSimplePushConfig.create((String)host.asText(), (int)port.asInt());
        JsonNode password = json.get("password");
        if (password != null) {
            builder.password(password.asText());
        }
        if ((useragentReaperTimeout = json.get("useragent-reaper-timeout")) != null) {
            builder.userAgentReaperTimeout(Long.valueOf(useragentReaperTimeout.asLong()));
        }
        if ((endpointHost = json.get("endpoint-host")) != null) {
            builder.endpointHost(endpointHost.asText());
        }
        if ((endpointPort = json.get("endpoint-port")) != null) {
            builder.endpointPort(endpointPort.asInt());
        }
        if ((endpointTls = json.get("endpoint-tls")) != null) {
            builder.endpointTls(endpointTls.asBoolean());
        }
        if ((endpointPrefix = json.get("endpoint-prefix")) != null) {
            builder.endpointPrefix(endpointPrefix.asText());
        }
        if ((ackInterval = json.get("ack-interval")) != null) {
            builder.ackInterval(Long.valueOf(ackInterval.asLong()));
        }
        if ((notifierMaxThreads = json.get("notifier-max-threads")) != null) {
            builder.notifierMaxThreads(notifierMaxThreads.asInt());
        }
        return builder.build();
    }
}

