/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.netty;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2OrHttpChooser;
import javax.net.ssl.SSLEngine;
import org.jboss.aerogear.webpush.WebPushServer;
import org.jboss.aerogear.webpush.netty.WebPushHttp11Handler;
import org.jboss.aerogear.webpush.netty.WebPushHttp2Handler;

public class Http2OrHttpHandler
extends Http2OrHttpChooser {
    private static final int MAX_CONTENT_LENGTH = 102400;
    private final WebPushServer webPushServer;

    public Http2OrHttpHandler(WebPushServer webPushServer) {
        this(102400, webPushServer);
    }

    public Http2OrHttpHandler(int maxHttpContentLength, WebPushServer webPushServer) {
        super(maxHttpContentLength);
        this.webPushServer = webPushServer;
    }

    protected Http2OrHttpChooser.SelectedProtocol getProtocol(SSLEngine engine) {
        String[] protocols = engine.getSession().getProtocol().split(":");
        if (protocols.length > 1) {
            Http2OrHttpChooser.SelectedProtocol selectedProtocol = Http2OrHttpChooser.SelectedProtocol.protocol((String)protocols[1]);
            System.err.println("Selected Protocol is " + selectedProtocol);
            return selectedProtocol;
        }
        return Http2OrHttpChooser.SelectedProtocol.UNKNOWN;
    }

    protected ChannelHandler createHttp1RequestHandler() {
        return new WebPushHttp11Handler(this.webPushServer);
    }

    protected Http2ConnectionHandler createHttp2RequestHandler() {
        return new WebPushHttp2Handler(this.webPushServer);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (!cause.getMessage().equals("javax.net.ssl.SSLException: Received fatal alert: unknown_ca")) {
            ctx.fireExceptionCaught(cause);
        }
    }
}

