/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.AsciiString;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.EmptyHttp2Headers;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AttributeKey;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.jboss.aerogear.webpush.AggregateSubscription;
import org.jboss.aerogear.webpush.JsonMapper;
import org.jboss.aerogear.webpush.Registration;
import org.jboss.aerogear.webpush.Subscription;
import org.jboss.aerogear.webpush.WebPushServer;
import org.jboss.aerogear.webpush.netty.WebPushNettyServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebPushFrameListener
extends Http2FrameAdapter {
    public static final AsciiString LINK = new AsciiString((CharSequence)"link");
    public static final AsciiString ANY_ORIGIN = new AsciiString((CharSequence)"*");
    private static final AsciiString AGGREGATION_JSON = new AsciiString((CharSequence)"application/push-aggregation+json");
    private static final Logger LOGGER = LoggerFactory.getLogger(WebPushNettyServer.class);
    private static final ConcurrentHashMap<String, Optional<Client>> monitoredStreams = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> notificationStreams = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, AggregateSubscription> aggregateChannels = new ConcurrentHashMap();
    private static final AttributeKey<String> REG_ID = AttributeKey.valueOf((String)"regId");
    private static final String GET = "GET";
    private static final String POST = "POST";
    private static final String PUT = "PUT";
    private static final String DELETE = "DELETE";
    private static final String PATH_KEY = "webpush.path";
    private static final String METHOD_KEY = "webpush.method";
    private final WebPushServer webpushServer;
    private Http2ConnectionEncoder encoder;

    public WebPushFrameListener(WebPushServer webpushServer) {
        Objects.requireNonNull(webpushServer, "webpushServer must not be null");
        this.webpushServer = webpushServer;
    }

    public void encoder(Http2ConnectionEncoder encoder) {
        this.encoder = encoder;
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endStream) throws Http2Exception {
        String path = headers.path().toString();
        LOGGER.info("onHeadersRead. streamId={}, method={}, path={}, endstream={}", new Object[]{streamId, headers.method(), path, endStream});
        WebPushFrameListener.setPathAndMethod(this.encoder.connection().stream(streamId), path, headers.method());
        switch (headers.method().toString()) {
            case "GET": {
                if (path.contains(Registration.Resource.REGISTRATION.resourceName())) {
                    this.handleMonitor(ctx, path, streamId, padding, headers);
                    break;
                }
                this.handleStatus(ctx, path, streamId, padding);
                break;
            }
            case "POST": {
                if (!path.contains(Registration.Resource.AGGREGATE.resourceName())) break;
                this.verifyAggregateMimeType(headers);
                break;
            }
            case "DELETE": {
                this.handleSubscriptionRemoval(ctx, path, streamId);
                break;
            }
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        Http2Stream stream = this.encoder.connection().stream(streamId);
        String path = (String)stream.getProperty((Object)PATH_KEY);
        LOGGER.info("onDataRead. streamId={}, path={}, endstream={}", new Object[]{streamId, path, endOfStream});
        if (path.contains(Registration.Resource.REGISTER.resourceName())) {
            this.handleDeviceRegister(ctx, streamId);
        } else if (path.contains(Registration.Resource.SUBSCRIBE.resourceName())) {
            this.handleSubscribe(ctx, path, streamId);
        } else if (path.contains(Registration.Resource.AGGREGATE.resourceName())) {
            this.handleAggregateSubscribe(ctx, path, streamId, data);
        } else {
            this.handleNotification(ctx, streamId, data, padding, path);
        }
        return super.onDataRead(ctx, streamId, data, padding, endOfStream);
    }

    public void shutdown() {
        monitoredStreams.entrySet().stream().forEach(kv -> ((Optional)kv.getValue()).ifPresent(client -> ((Client)client).ctx.close()));
        monitoredStreams.clear();
        aggregateChannels.clear();
        notificationStreams.clear();
    }

    public void disconnect(ChannelHandlerContext ctx) {
        Optional<Client> removed;
        Optional<Object> regId = Optional.ofNullable(ctx.attr(REG_ID).get());
        if (regId.isPresent() && (removed = monitoredStreams.remove(regId.get())) != null && removed.isPresent()) {
            Client client = removed.get();
            LOGGER.info("Removed client regId{}", (Object)client);
        }
        LOGGER.info("Disconnected channel {}", (Object)ctx.channel().id());
    }

    private void handleNotification(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, String path) {
        int readableBytes = data.readableBytes();
        if ((long)readableBytes > this.webpushServer.config().messageMaxSize() && (long)readableBytes >= 4096L) {
            this.encoder.writeHeaders(ctx, streamId, this.messageToLarge(), 0, true, ctx.newPromise());
        } else {
            String endpoint = WebPushFrameListener.extractEndpointToken(path);
            this.handleNotify(endpoint, data, padding, (Http2ConnectionEncoder e) -> this.encoder.writeHeaders(ctx, streamId, this.acceptedHeaders(), 0, true, ctx.newPromise()));
            Optional.ofNullable(aggregateChannels.get(endpoint)).ifPresent(agg -> agg.subscriptions().stream().forEach(entry -> this.handleNotify(entry.endpoint(), data.copy(), padding, (Http2ConnectionEncoder e) -> {})));
        }
    }

    private void handleNotify(String endpoint, String data, int padding, Consumer<Http2ConnectionEncoder> consumer) {
        this.handleNotify(endpoint, Unpooled.copiedBuffer((CharSequence)data, (Charset)CharsetUtil.UTF_8), padding, consumer);
    }

    private void handleNotify(String endpoint, ByteBuf data, int padding, Consumer<Http2ConnectionEncoder> consumer) {
        Optional<String> optionalRegId = this.subscriptionRegIdForEndpoint(WebPushFrameListener.extractEndpointToken(endpoint));
        if (optionalRegId.isPresent()) {
            Optional<Client> optionalClient = this.clientForRegId(optionalRegId.get());
            if (optionalClient.isPresent()) {
                Client client = optionalClient.get();
                LOGGER.info("Handle notification {} payload {}", (Object)client, (Object)data.toString(CharsetUtil.UTF_8));
                if (!client.isHeadersSent()) {
                    client.encoder.writeHeaders(client.ctx, client.streamId, (Http2Headers)EmptyHttp2Headers.INSTANCE, 0, false, client.ctx.newPromise()).addListener(WebPushFrameListener::logFutureError);
                    client.headersSent();
                }
                client.encoder.writeData(client.ctx, client.streamId, data.retain(), padding, false, client.ctx.newPromise()).addListener(WebPushFrameListener::logFutureError);
                this.webpushServer.setMessage(endpoint, Optional.empty());
            } else {
                this.webpushServer.setMessage(endpoint, Optional.of(data.toString(CharsetUtil.UTF_8)));
                consumer.accept(this.encoder);
            }
        }
    }

    private Optional<String> subscriptionRegIdForEndpoint(String endpointToken) {
        return Optional.ofNullable(notificationStreams.get(endpointToken));
    }

    private Optional<Client> clientForRegId(String regId) {
        return Optional.ofNullable(monitoredStreams.get(regId)).orElse(Optional.empty());
    }

    private static void logFutureError(Future future) {
        if (!future.isSuccess()) {
            LOGGER.error("ChannelFuture failed. Cause: {}", future.cause());
        }
    }

    private void handleDeviceRegister(ChannelHandlerContext ctx, int streamId) {
        Registration registration = this.webpushServer.register();
        ctx.attr(REG_ID).set((Object)registration.id());
        this.encoder.writeHeaders(ctx, streamId, this.registrationHeaders(registration), 0, true, ctx.newPromise());
        LOGGER.info("Registered {} " + registration);
    }

    private static AsciiString asLink(URI contextUri, String relationType) {
        return new AsciiString((CharSequence)("<" + contextUri + ">;rel=\"" + relationType + "\""));
    }

    private void handleSubscribe(ChannelHandlerContext ctx, String path, int streamId) {
        Optional subscription = WebPushFrameListener.extractRegistrationId(path, Registration.Resource.SUBSCRIBE.resourceName()).flatMap(arg_0 -> ((WebPushServer)this.webpushServer).newSubscription(arg_0));
        subscription.ifPresent(ch -> {
            LOGGER.info("Subscription {} " + ch);
            notificationStreams.put(ch.endpoint(), ch.registrationId());
            this.encoder.writeHeaders(ctx, streamId, this.createdHeaders((Subscription)ch), 0, true, ctx.newPromise());
        });
    }

    private Http2Headers registrationHeaders(Registration registration) {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.CREATED.codeAsText()).set(HttpHeaderNames.LOCATION, new AsciiString((CharSequence)registration.uri().toString())).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN).set(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, new AsciiString((CharSequence)"Link, Cache-Control, Location")).set(LINK, new AsciiString[]{WebPushFrameListener.asLink(registration.uri(), Registration.WebLink.REGISTRATION.toString()), WebPushFrameListener.asLink(registration.subscribeUri(), Registration.WebLink.SUBSCRIBE.toString()), WebPushFrameListener.asLink(registration.aggregateUri(), Registration.WebLink.AGGREGATE.toString())}).set(HttpHeaderNames.CACHE_CONTROL, WebPushFrameListener.privateCacheWithMaxAge(this.webpushServer.config().registrationMaxAge()));
    }

    private Http2Headers acceptedHeaders() {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.OK.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN).set(HttpHeaderNames.CACHE_CONTROL, WebPushFrameListener.privateCacheWithMaxAge(this.webpushServer.config().messageMaxAge()));
    }

    private Http2Headers messageToLarge() {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.REQUEST_ENTITY_TOO_LARGE.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN);
    }

    private void handleAggregateSubscribe(ChannelHandlerContext ctx, String path, int streamId, ByteBuf data) {
        LOGGER.info("Aggregate payload={}", (Object)data.toString(CharsetUtil.UTF_8));
        Optional subscription = WebPushFrameListener.extractRegistrationId(path, "aggregate").flatMap(arg_0 -> ((WebPushServer)this.webpushServer).newSubscription(arg_0));
        AggregateSubscription aggregateSubscription = (AggregateSubscription)JsonMapper.fromJson((String)data.toString(CharsetUtil.UTF_8), AggregateSubscription.class);
        subscription.ifPresent(ch -> {
            LOGGER.info("Created aggregate subscription {} " + ch);
            aggregateChannels.put(ch.endpoint(), aggregateSubscription);
            this.encoder.writeHeaders(ctx, streamId, this.createdHeaders((Subscription)ch), 0, true, ctx.newPromise());
        });
    }

    private Http2Headers createdHeaders(Subscription subscription) {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.CREATED.codeAsText()).set(HttpHeaderNames.LOCATION, new AsciiString((CharSequence)("/webpush/" + subscription.endpoint()))).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN).set(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, new AsciiString((CharSequence)"Location")).set(HttpHeaderNames.CACHE_CONTROL, WebPushFrameListener.privateCacheWithMaxAge(this.webpushServer.config().subscriptionMaxAge()));
    }

    private static void setPathAndMethod(Http2Stream stream, String path, AsciiString method) {
        stream.setProperty((Object)PATH_KEY, (Object)path);
        stream.setProperty((Object)METHOD_KEY, (Object)method);
    }

    private void verifyAggregateMimeType(Http2Headers headers) {
        if (!AGGREGATION_JSON.equals(headers.get((Object)HttpHeaderNames.CONTENT_TYPE))) {
            // empty if block
        }
    }

    private static AsciiString privateCacheWithMaxAge(long maxAge) {
        return new AsciiString((CharSequence)("private, max-age=" + maxAge));
    }

    private void handleSubscriptionRemoval(ChannelHandlerContext ctx, String path, int streamId) {
        String endpointToken = WebPushFrameListener.extractEndpointToken(path);
        Optional subscription = this.webpushServer.subscription(endpointToken);
        if (subscription.isPresent()) {
            this.webpushServer.removeSubscription((Subscription)subscription.get());
            notificationStreams.remove(endpointToken);
            this.encoder.writeHeaders(ctx, streamId, WebPushFrameListener.okHeaders(), 0, true, ctx.newPromise());
        } else {
            this.encoder.writeHeaders(ctx, streamId, WebPushFrameListener.notFoundHeaders(), 0, true, ctx.newPromise());
        }
    }

    private void handleMonitor(ChannelHandlerContext ctx, String path, int streamId, int padding, Http2Headers headers) {
        Optional registration = WebPushFrameListener.extractRegistrationId(path, Registration.Resource.REGISTRATION.resourceName()).flatMap(arg_0 -> ((WebPushServer)this.webpushServer).registration(arg_0));
        registration.ifPresent(reg -> {
            int pushStreamId = this.encoder.connection().local().nextStreamId();
            Client client = new Client(ctx, pushStreamId, this.encoder);
            monitoredStreams.put(reg.id(), Optional.of(client));
            this.encoder.writePushPromise(ctx, streamId, pushStreamId, this.monitorHeaders((Registration)reg), 0, ctx.newPromise());
            LOGGER.info("Monitor ctx={}, registrationId={}, pushPromiseStreamId={}, headers={}", new Object[]{ctx, reg.id(), pushStreamId, this.monitorHeaders((Registration)reg)});
            Optional<AsciiString> wait = Optional.ofNullable(headers.get((Object)new AsciiString((CharSequence)"prefer"))).filter(val -> val.toString().equals("wait=0"));
            wait.ifPresent(s -> notificationStreams.entrySet().stream().filter(kv -> ((String)kv.getValue()).equals(reg.id())).forEach(e -> {
                String endpoint = (String)e.getKey();
                Optional<Subscription> sub = this.webpushServer.subscription(endpoint).filter(ch -> ch.message().isPresent());
                sub.ifPresent(ch -> this.handleNotify(endpoint, (String)ch.message().get(), padding, (Http2ConnectionEncoder q) -> {}));
            }));
        });
    }

    private void handleStatus(ChannelHandlerContext ctx, String path, int streamId, int padding) {
        String endpointToken = WebPushFrameListener.extractEndpointToken(path);
        Optional subscription = this.webpushServer.subscription(endpointToken);
        if (subscription.isPresent()) {
            LOGGER.info("Channel {}", (Object)subscription);
            Subscription ch = (Subscription)subscription.get();
            Optional message = ch.message();
            if (message.isPresent()) {
                this.encoder.writeHeaders(ctx, streamId, WebPushFrameListener.okHeaders(), 0, false, ctx.newPromise());
                this.encoder.writeData(ctx, streamId, Unpooled.copiedBuffer((CharSequence)((CharSequence)message.get()), (Charset)CharsetUtil.UTF_8), padding, false, ctx.newPromise());
                this.webpushServer.setMessage(ch.endpoint(), Optional.empty());
            } else {
                this.encoder.writeHeaders(ctx, streamId, WebPushFrameListener.noContentHeaders(), 0, true, ctx.newPromise());
            }
        } else {
            this.encoder.writeHeaders(ctx, streamId, WebPushFrameListener.notFoundHeaders(), 0, true, ctx.newPromise());
        }
    }

    private static Http2Headers noContentHeaders() {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.NO_CONTENT.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN);
    }

    private static Http2Headers notFoundHeaders() {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.NOT_FOUND.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN);
    }

    private Http2Headers monitorHeaders(Registration registration) {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.OK.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN).set(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, new AsciiString((CharSequence)"Link, Cache-Control")).set(LINK, new AsciiString[]{WebPushFrameListener.asLink(registration.subscribeUri(), Registration.WebLink.SUBSCRIBE.toString()), WebPushFrameListener.asLink(registration.aggregateUri(), Registration.WebLink.AGGREGATE.toString())}).set(HttpHeaderNames.CACHE_CONTROL, WebPushFrameListener.privateCacheWithMaxAge(this.webpushServer.config().registrationMaxAge()));
    }

    private static Http2Headers okHeaders() {
        return new DefaultHttp2Headers(false).status(HttpResponseStatus.OK.codeAsText()).set(HttpHeaderNames.ACCESS_CONTROL_ALLOW_ORIGIN, ANY_ORIGIN).set(HttpHeaderNames.ACCESS_CONTROL_EXPOSE_HEADERS, HttpHeaderNames.CONTENT_TYPE);
    }

    private static Optional<String> extractRegistrationId(String path, String segment) {
        try {
            String subpath = path.substring(path.indexOf(segment) + segment.length() + 1);
            return Optional.of(subpath.subSequence(subpath.lastIndexOf(47) + 1, subpath.length()).toString());
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private static String extractEndpointToken(String path) {
        return path.substring(path.lastIndexOf("/") + 1);
    }

    private static class Client {
        private final ChannelHandlerContext ctx;
        private final Http2ConnectionEncoder encoder;
        private final int streamId;
        private volatile boolean headersSent;

        Client(ChannelHandlerContext ctx, int streamId, Http2ConnectionEncoder encoder) {
            this.ctx = ctx;
            this.streamId = streamId;
            this.encoder = encoder;
        }

        boolean isHeadersSent() {
            return this.headersSent;
        }

        void headersSent() {
            this.headersSent = true;
        }

        public String toString() {
            return "Client[streamid=" + this.streamId + ", ctx=" + this.ctx + ", headersSent=" + this.headersSent + "]";
        }
    }
}

