/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins;

import com.google.common.jenkins_client_jarjar.base.Function;
import com.google.common.jenkins_client_jarjar.base.Optional;
import com.google.common.jenkins_client_jarjar.collect.ImmutableMap;
import com.google.common.jenkins_client_jarjar.collect.Maps;
import com.offbytwo.jenkins.client.JenkinsHttpClient;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.helper.JenkinsVersion;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.Computer;
import com.offbytwo.jenkins.model.ComputerSet;
import com.offbytwo.jenkins.model.FolderJob;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.JobConfiguration;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.LabelWithDetails;
import com.offbytwo.jenkins.model.MainView;
import com.offbytwo.jenkins.model.MavenJobWithDetails;
import com.offbytwo.jenkins.model.Plugin;
import com.offbytwo.jenkins.model.PluginManager;
import com.offbytwo.jenkins.model.Queue;
import com.offbytwo.jenkins.model.QueueItem;
import com.offbytwo.jenkins.model.QueueReference;
import com.offbytwo.jenkins.model.View;
import com.offbytwo.jenkins.model.credentials.Credential;
import com.offbytwo.jenkins.model.credentials.CredentialManager;
import java.io.IOException;
import java.net.URI;
import java.rmi.server.ExportException;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.entity.ContentType;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsServer {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private final JenkinsHttpClient client;
    private CredentialManager credentialManager;

    public JenkinsServer(URI serverUri) {
        this(new JenkinsHttpClient(serverUri));
    }

    public JenkinsServer(URI serverUri, String username, String passwordOrToken) {
        this(new JenkinsHttpClient(serverUri, username, passwordOrToken));
    }

    public JenkinsServer(JenkinsHttpClient client) {
        this.client = client;
    }

    public boolean isRunning() {
        try {
            this.client.get("/");
            return true;
        }
        catch (IOException e) {
            this.LOGGER.debug("isRunning()", (Throwable)e);
            return false;
        }
    }

    public JenkinsVersion getVersion() {
        if (this.client.getJenkinsVersion().isEmpty()) {
            this.isRunning();
        }
        JenkinsVersion jv = new JenkinsVersion(this.client.getJenkinsVersion());
        return jv;
    }

    public Map<String, Job> getJobs() throws IOException {
        return this.getJobs(null, null);
    }

    public Map<String, Job> getJobs(FolderJob folder) throws IOException {
        return this.getJobs(folder, null);
    }

    public Map<String, Job> getJobs(String view) throws IOException {
        return this.getJobs(null, view);
    }

    public Map<String, Job> getJobs(FolderJob folder, String view) throws IOException {
        String path = this.toBaseUrl(folder);
        Class<MainView> viewClass = MainView.class;
        if (view != null) {
            path = path + "view/" + EncodingUtils.encode(view) + "/";
            viewClass = View.class;
        }
        List<Job> jobs = this.client.get(path, viewClass).getJobs();
        return Maps.uniqueIndex(jobs, (Function)new Function<Job, String>(){

            public String apply(Job job) {
                job.setClient(JenkinsServer.this.client);
                return job.getName();
            }
        });
    }

    public Map<String, View> getViews() throws IOException {
        return this.getViews(null);
    }

    public Map<String, View> getViews(FolderJob folder) throws IOException {
        List<View> views = this.client.get(this.toBaseUrl(folder) + "?tree=views[name,url,jobs[name,url]]", MainView.class).getViews();
        return Maps.uniqueIndex(views, (Function)new Function<View, String>(){

            public String apply(View view) {
                view.setClient(JenkinsServer.this.client);
                for (Job job : view.getJobs()) {
                    job.setClient(JenkinsServer.this.client);
                }
                for (View item : view.getViews()) {
                    item.setClient(JenkinsServer.this.client);
                }
                return view.getName();
            }
        });
    }

    public View getView(String name) throws IOException {
        return this.getView(null, name);
    }

    public View getView(FolderJob folder, String name) throws IOException {
        try {
            View resultView = this.client.get(this.toViewBaseUrl(folder, name) + "/", View.class);
            resultView.setClient(this.client);
            for (Job job : resultView.getJobs()) {
                job.setClient(this.client);
            }
            for (View view : resultView.getViews()) {
                view.setClient(this.client);
            }
            return resultView;
        }
        catch (HttpResponseException e) {
            this.LOGGER.debug("getView(folder={}, name={}) status={}", new Object[]{folder, name, e.getStatusCode()});
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public JobWithDetails getJob(String jobName) throws IOException {
        return this.getJob(null, jobName);
    }

    public JobWithDetails getJob(FolderJob folder, String jobName) throws IOException {
        try {
            JobWithDetails job = this.client.get(this.toJobBaseUrl(folder, jobName), JobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            this.LOGGER.debug("getJob(folder={}, jobName={}) status={}", new Object[]{folder, jobName, e.getStatusCode()});
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public MavenJobWithDetails getMavenJob(String jobName) throws IOException {
        return this.getMavenJob(null, jobName);
    }

    public MavenJobWithDetails getMavenJob(FolderJob folder, String jobName) throws IOException {
        try {
            MavenJobWithDetails job = this.client.get(this.toJobBaseUrl(folder, jobName), MavenJobWithDetails.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            this.LOGGER.debug("getMavenJob(jobName={}) status={}", (Object)jobName, (Object)e.getStatusCode());
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public Optional<FolderJob> getFolderJob(Job job) throws IOException {
        try {
            FolderJob folder = this.client.get(job.getUrl(), FolderJob.class);
            if (!folder.isFolder()) {
                return Optional.absent();
            }
            folder.setClient(this.client);
            return Optional.of((Object)folder);
        }
        catch (HttpResponseException e) {
            this.LOGGER.debug("getForlderJob(job={}) status={}", (Object)job, (Object)e.getStatusCode());
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void createJob(String jobName, String jobXml) throws IOException {
        this.createJob(null, jobName, jobXml, false);
    }

    public void createJob(String jobName, String jobXml, Boolean crumbFlag) throws IOException {
        this.createJob(null, jobName, jobXml, crumbFlag);
    }

    public void createJob(FolderJob folder, String jobName, String jobXml) throws IOException {
        this.createJob(folder, jobName, jobXml, false);
    }

    public void createJob(FolderJob folder, String jobName, String jobXml, Boolean crumbFlag) throws IOException {
        this.client.post_xml(this.toBaseUrl(folder) + "createItem?name=" + EncodingUtils.encodeParam(jobName), jobXml, crumbFlag);
    }

    public void createView(String viewName, String viewXml) throws IOException {
        this.createView(null, viewName, viewXml, false);
    }

    public void createView(String viewName, String viewXml, Boolean crumbFlag) throws IOException {
        this.createView(null, viewName, viewXml, crumbFlag);
    }

    public void createView(FolderJob folder, String viewName, String viewXml) throws IOException {
        this.createView(folder, viewName, viewXml, false);
    }

    public void createView(FolderJob folder, String viewName, String viewXml, Boolean crumbFlag) throws IOException {
        this.client.post_xml(this.toBaseUrl(folder) + "createView?name=" + EncodingUtils.encodeParam(viewName), viewXml, crumbFlag);
    }

    public void createFolder(String folderName) throws IOException {
        this.createFolder(null, folderName, false);
    }

    public void createFolder(String folderName, Boolean crumbFlag) throws IOException {
        this.createFolder(null, folderName, crumbFlag);
    }

    public void createFolder(FolderJob folder, String jobName) throws IOException {
        this.createFolder(folder, jobName, false);
    }

    public void createFolder(FolderJob folder, String jobName, Boolean crumbFlag) throws IOException {
        ImmutableMap params = ImmutableMap.of((Object)"mode", (Object)"com.cloudbees.hudson.plugins.folder.Folder", (Object)"name", (Object)EncodingUtils.encodeParam(jobName), (Object)"from", (Object)"", (Object)"Submit", (Object)"OK");
        this.client.post_form(this.toBaseUrl(folder) + "createItem?", (Map<String, String>)params, crumbFlag);
    }

    public String getJobXml(String jobName) throws IOException {
        return this.getJobXml(null, jobName);
    }

    public String getJobXml(FolderJob folder, String jobName) throws IOException {
        return this.client.get(this.toJobBaseUrl(folder, jobName) + "/config.xml");
    }

    public LabelWithDetails getLabel(String labelName) throws IOException {
        return this.client.get("/label/" + EncodingUtils.encode(labelName), LabelWithDetails.class);
    }

    public Map<String, Computer> getComputers() throws IOException {
        List<Computer> computers = this.client.get("computer/", Computer.class).getComputers();
        return Maps.uniqueIndex(computers, (Function)new Function<Computer, String>(){

            public String apply(Computer computer) {
                computer.setClient(JenkinsServer.this.client);
                return computer.getDisplayName().toLowerCase();
            }
        });
    }

    public ComputerSet getComputerSet() throws IOException {
        return this.client.get("computer/?depth=2", ComputerSet.class);
    }

    public PluginManager getPluginManager() throws IOException {
        return this.client.get("pluginManager/?depth=2", PluginManager.class);
    }

    public void updateView(String viewName, String viewXml) throws IOException {
        this.updateView(viewName, viewXml, true);
    }

    public void updateView(String viewName, String viewXml, boolean crumbFlag) throws IOException {
        this.client.post_xml("/view/" + EncodingUtils.encode(viewName) + "/config.xml", viewXml, crumbFlag);
    }

    public void updateView(FolderJob folder, String viewName, String viewXml) throws IOException {
        this.client.post_xml(this.toBaseUrl(folder) + "view/" + EncodingUtils.encode(viewName) + "/config.xml", viewXml, true);
    }

    public void updateView(FolderJob folder, String viewName, String viewXml, boolean crumbFlag) throws IOException {
        this.client.post_xml(this.toBaseUrl(folder) + "view/" + EncodingUtils.encode(viewName) + "/config.xml", viewXml, crumbFlag);
    }

    public void updateJob(String jobName, String jobXml) throws IOException {
        this.updateJob(jobName, jobXml, true);
    }

    public void updateJob(String jobName, String jobXml, boolean crumbFlag) throws IOException {
        this.updateJob(null, jobName, jobXml, crumbFlag);
    }

    public void updateJob(FolderJob folder, String jobName, String jobXml, boolean crumbFlag) throws IOException {
        this.client.post_xml(this.toJobBaseUrl(folder, jobName) + "/config.xml", jobXml, crumbFlag);
    }

    public void addStringParam(String jobName, String name, String description, String defaultValue) throws IOException, JAXBException, DocumentException {
        String jobXml = this.getJobXml(jobName);
        JobConfiguration jobConf = new JobConfiguration(jobXml);
        jobXml = jobConf.addStringParam(name, description, defaultValue).asXml();
        this.updateJob(jobName, jobXml);
    }

    public void quietDown() throws IOException {
        try {
            this.client.get("/quietDown/");
        }
        catch (ClientProtocolException e) {
            this.LOGGER.error("quietDown()", (Throwable)e);
        }
    }

    public void cancelQuietDown() throws IOException {
        try {
            this.client.post("/cancelQuietDown/");
        }
        catch (ClientProtocolException e) {
            this.LOGGER.error("cancelQuietDown()", (Throwable)e);
        }
    }

    public void deleteJob(FolderJob folder, String jobName) throws IOException {
        this.deleteJob(folder, jobName, false);
    }

    public void deleteJob(FolderJob folder, String jobName, boolean crumbFlag) throws IOException {
        this.client.post(this.toJobBaseUrl(folder, jobName) + "/doDelete", crumbFlag);
    }

    public void deleteJob(String jobName) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/doDelete");
    }

    public void deleteJob(String jobName, boolean crumbFlag) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/doDelete", crumbFlag);
    }

    public void disableJob(String jobName) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/disable");
    }

    public void disableJob(String jobName, boolean crumbFlag) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/disable", crumbFlag);
    }

    public void enableJob(String jobName) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/enable");
    }

    public void enableJob(String jobName, boolean crumbFlag) throws IOException {
        this.client.post("/job/" + EncodingUtils.encode(jobName) + "/enable", crumbFlag);
    }

    public String runScript(String script) throws IOException {
        return this.runScript(script, false);
    }

    public String runScript(String script, boolean crumbFlag) throws IOException {
        return this.client.post_text("/scriptText", "script=" + script, ContentType.APPLICATION_FORM_URLENCODED, crumbFlag);
    }

    public Queue getQueue() throws IOException {
        return this.client.get("queue/?depth=1", Queue.class);
    }

    public QueueItem getQueueItem(QueueReference ref) throws IOException {
        try {
            String url = ref.getQueueItemUrlPart();
            QueueItem queueItem = this.client.get(url, QueueItem.class);
            queueItem.setClient(this.client);
            return queueItem;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public Build getBuild(QueueItem q) throws IOException {
        try {
            String url = q.getExecutable().getUrl();
            Build job = this.client.get(url, Build.class);
            job.setClient(this.client);
            return job;
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public void renameJob(String oldJobName, String newJobName) throws IOException {
        this.renameJob(null, oldJobName, newJobName, false);
    }

    public void renameJob(String oldJobName, String newJobName, Boolean crumbFlag) throws IOException {
        this.renameJob(null, oldJobName, newJobName, crumbFlag);
    }

    public void renameJob(FolderJob folder, String oldJobName, String newJobName) throws IOException {
        this.renameJob(folder, oldJobName, newJobName, false);
    }

    public void renameJob(FolderJob folder, String oldJobName, String newJobName, Boolean crumbFlag) throws IOException {
        this.client.post(this.toJobBaseUrl(folder, oldJobName) + "/doRename?newName=" + EncodingUtils.encodeParam(newJobName), crumbFlag);
    }

    private String toBaseUrl(FolderJob folder) {
        String path = "/";
        if (folder != null) {
            path = folder.getUrl();
        }
        return path;
    }

    private String toJobBaseUrl(FolderJob folder, String jobName) {
        return this.toBaseUrl(folder) + "job/" + EncodingUtils.encode(jobName);
    }

    private String toViewBaseUrl(FolderJob folder, String name) {
        return this.toBaseUrl(folder) + "view/" + EncodingUtils.encode(name);
    }

    public Map<String, Credential> listCredentials() throws IOException {
        return this.getCredentialManager().listCredentials();
    }

    public void createCredential(Credential credential, boolean crumbFlag) throws IOException {
        this.getCredentialManager().createCredential(credential, crumbFlag);
    }

    public void updateCredential(String credentialId, Credential credential, boolean crumbFlag) throws IOException {
        this.getCredentialManager().updateCredential(credentialId, credential, crumbFlag);
    }

    public void deleteCredential(String credentialId, boolean crumbFlag) throws IOException {
        this.getCredentialManager().deleteCredential(credentialId, crumbFlag);
    }

    private CredentialManager getCredentialManager() throws IOException {
        if (this.credentialManager == null) {
            Plugin credentialPlugin = this.findPluginWithName("credentials");
            if (credentialPlugin == null) {
                throw new ExportException("credential plugin is not installed");
            }
            String version = credentialPlugin.getVersion();
            this.credentialManager = new CredentialManager(version, this.client);
        }
        return this.credentialManager;
    }

    public Plugin findPluginWithName(final String pluginShortName) throws IOException {
        List<Plugin> plugins = this.getPluginManager().getPlugins();
        Object foundPlugin = CollectionUtils.find(plugins, (Predicate)new Predicate(){

            public boolean evaluate(Object o) {
                Plugin p = (Plugin)o;
                return p.getShortName().equalsIgnoreCase(pluginShortName);
            }
        });
        return foundPlugin == null ? null : (Plugin)foundPlugin;
    }
}

