/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.jenkins_client_jarjar.base.Function;
import com.google.common.jenkins_client_jarjar.base.Optional;
import com.google.common.jenkins_client_jarjar.base.Predicate;
import com.google.common.jenkins_client_jarjar.collect.Iterables;
import com.google.common.jenkins_client_jarjar.collect.Lists;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.helper.Range;
import com.offbytwo.jenkins.model.AllMavenBuilds;
import com.offbytwo.jenkins.model.Job;
import com.offbytwo.jenkins.model.MavenBuild;
import com.offbytwo.jenkins.model.MavenJob;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.HttpResponseException;

public class MavenJobWithDetails
extends MavenJob {
    private String displayName;
    private boolean buildable;
    private List<MavenBuild> builds;
    private MavenBuild firstBuild;
    private MavenBuild lastBuild;
    private MavenBuild lastCompletedBuild;
    private MavenBuild lastFailedBuild;
    private MavenBuild lastStableBuild;
    private MavenBuild lastSuccessfulBuild;
    private MavenBuild lastUnstableBuild;
    private MavenBuild lastUnsuccessfulBuild;
    private int nextBuildNumber;
    private List<Job> downstreamProjects;
    private List<Job> upstreamProjects;

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isBuildable() {
        return this.buildable;
    }

    public List<MavenBuild> getBuilds() {
        if (this.builds == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.builds, (Function)new Function<MavenBuild, MavenBuild>(){

            public MavenBuild apply(MavenBuild from) {
                return MavenJobWithDetails.this.buildWithClient(from);
            }
        });
    }

    public List<MavenBuild> getAllBuilds() throws IOException {
        String path = "/";
        try {
            List<MavenBuild> builds = this.client.get(path + "job/" + EncodingUtils.encode(this.getName()) + "?tree=allBuilds[number[*],url[*],queueId[*]]", AllMavenBuilds.class).getAllBuilds();
            if (builds == null) {
                return Collections.emptyList();
            }
            return Lists.transform(builds, (Function)new Function<MavenBuild, MavenBuild>(){

                public MavenBuild apply(MavenBuild from) {
                    return MavenJobWithDetails.this.buildWithClient(from);
                }
            });
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public List<MavenBuild> getAllBuilds(Range range) throws IOException {
        String path = "/job/" + EncodingUtils.encode(this.getName()) + "?tree=allBuilds[number[*],url[*],queueId[*]]";
        try {
            List<MavenBuild> builds = this.client.get(path + range.getRangeString(), AllMavenBuilds.class).getAllBuilds();
            if (builds == null) {
                return Collections.emptyList();
            }
            return Lists.transform(builds, (Function)new Function<MavenBuild, MavenBuild>(){

                public MavenBuild apply(MavenBuild from) {
                    return MavenJobWithDetails.this.buildWithClient(from);
                }
            });
        }
        catch (HttpResponseException e) {
            if (e.getStatusCode() == 404) {
                return null;
            }
            throw e;
        }
    }

    public MavenBuild getFirstBuild() {
        if (this.firstBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.firstBuild);
    }

    public MavenBuild getLastBuild() {
        if (this.lastBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastBuild);
    }

    public MavenBuild getLastCompletedBuild() {
        if (this.lastCompletedBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastCompletedBuild);
    }

    public MavenBuild getLastFailedBuild() {
        if (this.lastFailedBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastFailedBuild);
    }

    public MavenBuild getLastStableBuild() {
        if (this.lastStableBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastStableBuild);
    }

    public MavenBuild getLastSuccessfulBuild() {
        if (this.lastSuccessfulBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastSuccessfulBuild);
    }

    public MavenBuild getLastUnstableBuild() {
        if (this.lastUnstableBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastUnstableBuild);
    }

    public MavenBuild getLastUnsuccessfulBuild() {
        if (this.lastUnsuccessfulBuild == null) {
            return MavenBuild.BUILD_HAS_NEVER_RUN;
        }
        return this.buildWithClient(this.lastUnsuccessfulBuild);
    }

    public int getNextBuildNumber() {
        return this.nextBuildNumber;
    }

    public List<Job> getDownstreamProjects() {
        if (this.downstreamProjects == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.downstreamProjects, (Function)new MavenJobWithClient());
    }

    public List<Job> getUpstreamProjects() {
        if (this.upstreamProjects == null) {
            return Collections.emptyList();
        }
        return Lists.transform(this.upstreamProjects, (Function)new MavenJobWithClient());
    }

    public MavenBuild getBuildByNumber(final int buildNumber) {
        Predicate<MavenBuild> isMatchingBuildNumber = new Predicate<MavenBuild>(){

            public boolean apply(MavenBuild input) {
                return input.getNumber() == buildNumber;
            }
        };
        Optional optionalBuild = Iterables.tryFind(this.builds, (Predicate)isMatchingBuildNumber);
        return optionalBuild.orNull() == null ? null : this.buildWithClient((MavenBuild)optionalBuild.orNull());
    }

    private MavenBuild buildWithClient(MavenBuild from) {
        MavenBuild ret = new MavenBuild(from);
        ret.setClient(this.client);
        return ret;
    }

    private class MavenJobWithClient
    implements Function<Job, Job> {
        private MavenJobWithClient() {
        }

        public Job apply(Job job) {
            job.setClient(MavenJobWithDetails.this.client);
            return job;
        }
    }
}

