/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model.credentials;

import com.offbytwo.jenkins.model.credentials.Credential;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class CertificateCredential
extends Credential {
    public static final String TYPENAME = "Certificate";
    private static final String BASECLASS = "com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl";
    private static final String FILE_ON_MASTER_KEYSTORE_SOURCE_CLASS = "com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl$FileOnMasterKeyStoreSource";
    private static final String UPLOAD_KEYSTORE_SOURCE_CLASS = "com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl$UploadedKeyStoreSource";
    private String password;
    private String certificatePath;
    private byte[] certificateContent;
    private CERTIFICATE_SOURCE_TYPES certificateSourceType;

    public CertificateCredential() {
        this.setTypeName(TYPENAME);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCertificatePath() {
        return this.certificatePath;
    }

    public void setCertificatePath(String certificatePath) {
        this.certificatePath = certificatePath;
    }

    public byte[] getCertificateContent() {
        return this.certificateContent;
    }

    public void setCertificateContent(byte[] certificateContent) {
        this.certificateContent = certificateContent;
    }

    public CERTIFICATE_SOURCE_TYPES getCertificateSourceType() {
        return this.certificateSourceType;
    }

    public void setCertificateSourceType(CERTIFICATE_SOURCE_TYPES certificateSourceType) {
        this.certificateSourceType = certificateSourceType;
    }

    @Override
    public Map<String, Object> dataForCreate() {
        HashMap<String, String> certificateSourceMap = new HashMap<String, String>();
        certificateSourceMap.put("value", String.valueOf(this.getCertificateSourceType().getCertStoreType()));
        certificateSourceMap.put("stapler-class", this.getCertificateSourceType().getCertStoreClass());
        certificateSourceMap.put("$class", this.getCertificateSourceType().getCertStoreClass());
        if (this.getCertificateSourceType() == CERTIFICATE_SOURCE_TYPES.FILE_ON_MASTER) {
            certificateSourceMap.put("keyStoreFile", this.getCertificatePath());
        } else if (this.getCertificateSourceType() == CERTIFICATE_SOURCE_TYPES.UPLOAD_CERT_FILE) {
            certificateSourceMap.put("uploadedKeystore", Base64.encodeBase64String((byte[])this.getCertificateContent()));
        }
        HashMap<String, Object> innerMap = new HashMap<String, Object>();
        innerMap.put("scope", "GLOBAL");
        innerMap.put("id", this.getId());
        innerMap.put("description", this.getDescription());
        innerMap.put("password", this.getPassword());
        innerMap.put("stapler-class", BASECLASS);
        innerMap.put("$class", BASECLASS);
        innerMap.put("keyStoreSource", certificateSourceMap);
        HashMap<String, Object> jsonData = new HashMap<String, Object>();
        jsonData.put("", "1");
        jsonData.put("credentials", innerMap);
        return jsonData;
    }

    @Override
    public Map<String, Object> dataForUpdate() {
        HashMap<String, String> certificateSourceMap = new HashMap<String, String>();
        certificateSourceMap.put("value", String.valueOf(this.getCertificateSourceType().getCertStoreType()));
        certificateSourceMap.put("stapler-class", this.getCertificateSourceType().getCertStoreClass());
        certificateSourceMap.put("$class", this.getCertificateSourceType().getCertStoreClass());
        if (this.getCertificateSourceType() == CERTIFICATE_SOURCE_TYPES.FILE_ON_MASTER) {
            certificateSourceMap.put("keyStoreFile", this.getCertificatePath());
        } else if (this.getCertificateSourceType() == CERTIFICATE_SOURCE_TYPES.UPLOAD_CERT_FILE) {
            certificateSourceMap.put("uploadedKeystore", Base64.encodeBase64String((byte[])this.getCertificateContent()));
        }
        HashMap<String, Object> jsonData = new HashMap<String, Object>();
        jsonData.put("scope", "GLOBAL");
        jsonData.put("id", this.getId());
        jsonData.put("description", this.getDescription());
        jsonData.put("password", this.getPassword());
        jsonData.put("stapler-class", BASECLASS);
        jsonData.put("$class", BASECLASS);
        jsonData.put("keyStoreSource", certificateSourceMap);
        return jsonData;
    }

    public static enum CERTIFICATE_SOURCE_TYPES {
        FILE_ON_MASTER("com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl$FileOnMasterKeyStoreSource", 0),
        UPLOAD_CERT_FILE("com.cloudbees.plugins.credentials.impl.CertificateCredentialsImpl$UploadedKeyStoreSource", 1);

        private String certStoreClass;
        private int certStoreType;

        private CERTIFICATE_SOURCE_TYPES(String storeClass, int storeType) {
            this.certStoreClass = storeClass;
            this.certStoreType = storeType;
        }

        public String getCertStoreClass() {
            return this.certStoreClass;
        }

        public int getCertStoreType() {
            return this.certStoreType;
        }
    }
}

