/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.jenkins_client_jarjar.collect;

import com.google.common.jenkins_client_jarjar.annotations.GwtCompatible;
import com.google.common.jenkins_client_jarjar.annotations.GwtIncompatible;
import com.google.common.jenkins_client_jarjar.collect.ImmutableAsList;
import com.google.common.jenkins_client_jarjar.collect.ImmutableCollection;
import com.google.common.jenkins_client_jarjar.collect.ImmutableList;
import com.google.common.jenkins_client_jarjar.collect.UnmodifiableListIterator;

@GwtCompatible(emulated=true)
class RegularImmutableAsList<E>
extends ImmutableAsList<E> {
    private final ImmutableCollection<E> delegate;
    private final ImmutableList<? extends E> delegateList;

    RegularImmutableAsList(ImmutableCollection<E> delegate, ImmutableList<? extends E> delegateList) {
        this.delegate = delegate;
        this.delegateList = delegateList;
    }

    RegularImmutableAsList(ImmutableCollection<E> delegate, Object[] array) {
        this(delegate, ImmutableList.asImmutableList(array));
    }

    @Override
    ImmutableCollection<E> delegateCollection() {
        return this.delegate;
    }

    ImmutableList<? extends E> delegateList() {
        return this.delegateList;
    }

    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        return this.delegateList.listIterator(index);
    }

    @Override
    @GwtIncompatible(value="not present in emulated superclass")
    int copyIntoArray(Object[] dst, int offset) {
        return this.delegateList.copyIntoArray(dst, offset);
    }

    @Override
    public E get(int index) {
        return this.delegateList.get(index);
    }
}

