/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.jenkins_client_jarjar.base.Function;
import com.google.common.jenkins_client_jarjar.collect.ImmutableMap;
import com.google.common.jenkins_client_jarjar.collect.Maps;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.model.Job;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class FolderJob
extends Job {
    private String displayName;
    private List<Job> jobs;

    public FolderJob() {
    }

    public FolderJob(String name, String url) {
        super(name, url);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isFolder() {
        return this.jobs != null;
    }

    public Map<String, Job> getJobs() {
        return Maps.uniqueIndex(this.jobs, new Function<Job, String>(){

            @Override
            public String apply(Job job) {
                job.setClient(FolderJob.this.client);
                return job.getName();
            }
        });
    }

    public Job getJob(String name) {
        return Maps.uniqueIndex(this.jobs, new Function<Job, String>(){

            @Override
            public String apply(Job job) {
                job.setClient(FolderJob.this.client);
                return job.getName();
            }
        }).get(name);
    }

    public void createFolder(String folderName) throws IOException {
        this.createFolder(folderName, false);
    }

    public void createFolder(String folderName, Boolean crumbFlag) throws IOException {
        ImmutableMap<String, String> params = ImmutableMap.of("mode", "com.cloudbees.hudson.plugins.folder.Folder", "name", EncodingUtils.encodeParam(folderName), "from", "", "Submit", "OK");
        this.client.post_form(this.getUrl() + "/createItem?", params, crumbFlag);
    }
}

