/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.client;

import java.util.Observable;
import java.util.Observer;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.client.PatchListener;
import org.jboss.aerogear.sync.client.PatchObservable;

public class DefaultPatchObservable<T>
extends Observable
implements PatchObservable<T> {
    @Override
    public void addPatchListener(PatchListener<T> listener) {
        this.addObserver(new PatchListenerAdapter<T>(listener));
    }

    @Override
    public void removePatchListener(PatchListener<T> listener) {
        this.deleteObserver(new PatchListenerAdapter<T>(listener));
    }

    @Override
    public void removePatchListeners() {
        this.deleteObservers();
    }

    @Override
    public void notifyPatched(ClientDocument<T> patchedDocument) {
        this.notifyObservers(patchedDocument);
    }

    @Override
    public int countPatchListeners() {
        return this.countObservers();
    }

    @Override
    public void changed() {
        this.setChanged();
    }

    private static class PatchListenerAdapter<T>
    implements Observer {
        private final PatchListener<T> listener;

        PatchListenerAdapter(PatchListener<T> listener) {
            this.listener = listener;
        }

        @Override
        public void update(Observable ignored, Object arg) {
            if (arg instanceof ClientDocument) {
                this.listener.patched((ClientDocument)arg);
            }
        }
    }
}

