/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.Queue;
import org.jboss.aerogear.sync.BackupShadowDocument;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.DefaultBackupShadowDocument;
import org.jboss.aerogear.sync.DefaultShadowDocument;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Document;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.client.ClientDataStore;
import org.jboss.aerogear.sync.client.ClientSynchronizer;
import org.jboss.aerogear.sync.client.PatchListener;
import org.jboss.aerogear.sync.client.PatchObservable;

public class ClientSyncEngine<T, S extends Edit<? extends Diff>> {
    private static final ObjectMapper OM = new ObjectMapper();
    private final ClientSynchronizer<T, S> clientSynchronizer;
    private final ClientDataStore<T, S> dataStore;
    private final PatchObservable<T> patchObservable;

    public ClientSyncEngine(ClientSynchronizer<T, S> clientSynchronizer, ClientDataStore<T, S> dataStore, PatchObservable<T> patchObservable) {
        this.clientSynchronizer = clientSynchronizer;
        this.dataStore = dataStore;
        this.patchObservable = patchObservable;
    }

    public void addDocument(ClientDocument<T> document) {
        this.saveDocument(document);
        this.saveBackupShadow(this.saveShadow((ShadowDocument<T>)new DefaultShadowDocument(0L, 0L, document)));
    }

    public PatchMessage<S> diff(ClientDocument<T> document) {
        String documentId = document.id();
        String clientId = document.clientId();
        ShadowDocument<T> shadow = this.getShadowDocument(documentId, clientId);
        S edit = this.serverDiff(document, shadow);
        this.saveEdits(edit, documentId, clientId);
        ShadowDocument<T> patchedShadow = this.diffPatchShadow(shadow, edit);
        this.saveShadow(this.incrementClientVersion(patchedShadow));
        return this.getPendingEdits(document.id(), document.clientId());
    }

    public void patch(PatchMessage<S> patchMessage) {
        ShadowDocument<T> patchedShadow = this.patchShadow(patchMessage);
        this.patchDocument(patchedShadow);
        this.saveBackupShadow(patchedShadow);
    }

    public PatchMessage<S> patchMessageFromJson(String json) {
        return this.clientSynchronizer.patchMessageFromJson(json);
    }

    public String documentToJson(ClientDocument<T> document) {
        ObjectNode objectNode = OM.createObjectNode();
        objectNode.put("msgType", "add");
        objectNode.put("id", document.id());
        objectNode.put("clientId", document.clientId());
        this.clientSynchronizer.addContent(document.content(), objectNode, "content");
        return objectNode.toString();
    }

    public PatchMessage<S> createPatchMessage(String documentId, String clientId, Queue<S> edits) {
        return this.clientSynchronizer.createPatchMessage(documentId, clientId, edits);
    }

    private ShadowDocument<T> diffPatchShadow(ShadowDocument<T> shadow, S edit) {
        return this.clientSynchronizer.patchShadow(edit, shadow);
    }

    public void addPatchListener(PatchListener<T> patchListener) {
        this.patchObservable.addPatchListener(patchListener);
    }

    public void removePatchListener(PatchListener<T> patchListener) {
        this.patchObservable.removePatchListener(patchListener);
    }

    public void removePatchListeners() {
        this.patchObservable.removePatchListeners();
    }

    public int countPatchListeners() {
        return this.patchObservable.countPatchListeners();
    }

    private ShadowDocument<T> patchShadow(PatchMessage<S> patchMessage) {
        String documentId = patchMessage.documentId();
        String clientId = patchMessage.clientId();
        ShadowDocument<T> shadow = this.getShadowDocument(documentId, clientId);
        Iterator iterator = patchMessage.edits().iterator();
        while (iterator.hasNext()) {
            Edit edit = (Edit)iterator.next();
            if (this.clientPacketDropped(edit, shadow)) {
                shadow = this.restoreBackup(shadow, edit);
                continue;
            }
            if (this.hasServerVersion(edit, shadow)) {
                this.discardEdit(edit, documentId, clientId, iterator);
                continue;
            }
            if (!this.allVersionsMatch(edit, shadow) && !this.isSeedVersion(edit)) continue;
            ShadowDocument patchedShadow = this.clientSynchronizer.patchShadow(edit, shadow);
            if (this.isSeedVersion(edit)) {
                shadow = this.saveShadowAndRemoveEdit(this.withClientVersion(patchedShadow, 0L), edit);
                continue;
            }
            shadow = this.saveShadowAndRemoveEdit(this.incrementServerVersion(patchedShadow), edit);
        }
        return shadow;
    }

    private boolean isSeedVersion(S edit) {
        return edit.clientVersion() == -1L;
    }

    private ShadowDocument<T> restoreBackup(ShadowDocument<T> shadow, S edit) {
        String clientId;
        String documentId = shadow.document().id();
        BackupShadowDocument<T> backup = this.getBackupShadowDocument(documentId, clientId = shadow.document().clientId());
        if (this.clientVersionMatch(edit, backup)) {
            ShadowDocument patchedShadow = this.clientSynchronizer.patchShadow(edit, backup.shadow());
            this.dataStore.removeEdits(documentId, clientId);
            return this.saveShadow(this.incrementServerVersion(patchedShadow), edit);
        }
        throw new IllegalStateException("Backup version [" + backup.version() + "] does not match edit client version [" + edit.clientVersion() + ']');
    }

    private boolean clientVersionMatch(S edit, BackupShadowDocument<T> backup) {
        return edit.clientVersion() == backup.version();
    }

    private ShadowDocument<T> saveShadowAndRemoveEdit(ShadowDocument<T> shadow, S edit) {
        this.dataStore.removeEdit(edit, shadow.document().id(), shadow.document().clientId());
        return this.saveShadow(shadow);
    }

    private ShadowDocument<T> saveShadow(ShadowDocument<T> shadow, S edit) {
        this.dataStore.removeEdit(edit, shadow.document().id(), shadow.document().clientId());
        return this.saveShadow(shadow);
    }

    private void discardEdit(S edit, String documentId, String clientId, Iterator<S> iterator) {
        this.dataStore.removeEdit(edit, documentId, clientId);
        iterator.remove();
    }

    private boolean allVersionsMatch(S edit, ShadowDocument<T> shadow) {
        return edit.serverVersion() == shadow.serverVersion() && edit.clientVersion() == shadow.clientVersion();
    }

    private boolean clientPacketDropped(S edit, ShadowDocument<T> shadow) {
        return edit.clientVersion() < shadow.clientVersion() && !this.isSeedVersion(edit);
    }

    private boolean hasServerVersion(S edit, ShadowDocument<T> shadow) {
        return edit.serverVersion() < shadow.serverVersion();
    }

    private Document<T> patchDocument(ShadowDocument<T> shadowDocument) {
        ClientDocument<T> clientDocument = this.getClientDocumentForShadow(shadowDocument);
        S edit = this.clientDiff(clientDocument, shadowDocument);
        ClientDocument<T> patched = this.patchDocument(edit, clientDocument);
        this.saveDocument(patched);
        this.saveBackupShadow(shadowDocument);
        this.patchObservable.changed();
        this.patchObservable.notifyPatched(patched);
        return patched;
    }

    private ClientDocument<T> patchDocument(S edit, ClientDocument<T> clientDocument) {
        return this.clientSynchronizer.patchDocument(edit, clientDocument);
    }

    private ClientDocument<T> getClientDocumentForShadow(ShadowDocument<T> shadow) {
        return this.dataStore.getClientDocument(shadow.document().id(), shadow.document().clientId());
    }

    private ShadowDocument<T> getShadowDocument(String documentId, String clientId) {
        return this.dataStore.getShadowDocument(documentId, clientId);
    }

    private BackupShadowDocument<T> getBackupShadowDocument(String documentId, String clientId) {
        return this.dataStore.getBackupShadowDocument(documentId, clientId);
    }

    private PatchMessage<S> getPendingEdits(String documentId, String clientId) {
        return this.clientSynchronizer.createPatchMessage(documentId, clientId, this.dataStore.getEdits(documentId, clientId));
    }

    private S clientDiff(ClientDocument<T> doc, ShadowDocument<T> shadow) {
        return (S)this.clientSynchronizer.clientDiff(shadow, doc);
    }

    private S serverDiff(ClientDocument<T> doc, ShadowDocument<T> shadow) {
        return (S)this.clientSynchronizer.serverDiff(doc, shadow);
    }

    private void saveEdits(S edit, String documentId, String clientId) {
        this.dataStore.saveEdits(edit, documentId, clientId);
    }

    private ShadowDocument<T> incrementClientVersion(ShadowDocument<T> shadow) {
        long clientVersion = shadow.clientVersion() + 1L;
        return this.newShadowDoc(shadow.serverVersion(), clientVersion, shadow.document());
    }

    private ShadowDocument<T> withClientVersion(ShadowDocument<T> shadow, long clientVersion) {
        return this.newShadowDoc(shadow.serverVersion(), clientVersion, shadow.document());
    }

    private ShadowDocument<T> saveShadow(ShadowDocument<T> newShadow) {
        this.dataStore.saveShadowDocument(newShadow);
        return newShadow;
    }

    private ShadowDocument<T> newShadowDoc(long serverVersion, long clientVersion, ClientDocument<T> doc) {
        return new DefaultShadowDocument(serverVersion, clientVersion, doc);
    }

    private ShadowDocument<T> incrementServerVersion(ShadowDocument<T> shadow) {
        long serverVersion = shadow.serverVersion() + 1L;
        return this.newShadowDoc(serverVersion, shadow.clientVersion(), shadow.document());
    }

    private void saveBackupShadow(ShadowDocument<T> newShadow) {
        this.dataStore.saveBackupShadowDocument((BackupShadowDocument)new DefaultBackupShadowDocument(newShadow.clientVersion(), newShadow));
    }

    private void saveDocument(ClientDocument<T> document) {
        this.dataStore.saveClientDocument(document);
    }
}

