/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server.wildfly;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Map;
import java.util.logging.Logger;
import javax.websocket.CloseReason;
import javax.websocket.OnClose;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.ServerEndpoint;
import org.jboss.aerogear.sync.Document;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.diffmatchpatch.JsonMapper;
import org.jboss.aerogear.sync.jsonpatch.JsonPatchEdit;
import org.jboss.aerogear.sync.jsonpatch.server.JsonPatchServerSynchronizer;
import org.jboss.aerogear.sync.server.MessageType;
import org.jboss.aerogear.sync.server.ServerDataStore;
import org.jboss.aerogear.sync.server.ServerInMemoryDataStore;
import org.jboss.aerogear.sync.server.ServerSyncEngine;
import org.jboss.aerogear.sync.server.ServerSynchronizer;
import org.jboss.aerogear.sync.server.Subscriber;
import org.jboss.aerogear.sync.server.wildfly.SyncEndpoint;
import org.jboss.aerogear.sync.server.wildfly.WildflySubscriber;

/*
 * Exception performing whole class analysis ignored.
 */
@ServerEndpoint(value="/sync")
public class SyncEndpoint {
    private static final JsonPatchServerSynchronizer synchronizer = new JsonPatchServerSynchronizer();
    private static final ServerInMemoryDataStore<JsonNode, JsonPatchEdit> dataStore = new ServerInMemoryDataStore();
    private static final ServerSyncEngine<JsonNode, JsonPatchEdit> syncEngine = new ServerSyncEngine((ServerSynchronizer)synchronizer, (ServerDataStore)dataStore);
    private static final String DOC_ADD = "DOC_ADD";
    private static final String WILDFLY_SUBSCRIBER = "WILDFLY_SUBSCRIBER";
    private static final Logger logger = Logger.getLogger(SyncEndpoint.class.getSimpleName());
    private static final String DOCUMENT_ID = "DOCUMENT_ID";

    @OnMessage
    public String onMessage(String message, Session webSocketSession) {
        JsonNode json = JsonMapper.asJsonNode((String)message);
        switch (1.$SwitchMap$org$jboss$aerogear$sync$server$MessageType[MessageType.from((String)json.get("msgType").asText()).ordinal()]) {
            case 1: {
                Document doc = syncEngine.documentFromJson(json);
                String clientId = json.get("clientId").asText();
                PatchMessage patchMessage = this.addSubscriber(doc, clientId, webSocketSession);
                webSocketSession.getUserProperties().put("DOC_ADD", true);
                return patchMessage.asJson();
            }
            case 2: {
                PatchMessage clientPatchMessage = syncEngine.patchMessageFromJson(json.toString());
                this.checkForReconnect(clientPatchMessage.documentId(), clientPatchMessage.clientId(), webSocketSession);
                this.patch(clientPatchMessage);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                return "{\"result\": \"Unknown msgType '" + json.get("msgType").asText() + "'\"}";
            }
        }
        return message;
    }

    @OnOpen
    public void onOpen(Session session) {
        logger.info("WebSocket opened: " + session.getId());
    }

    @OnClose
    public void onClose(CloseReason reason, Session webSocketSession) {
        logger.info("Closing a WebSocket due to " + reason.getReasonPhrase());
        WildflySubscriber subscriber = (WildflySubscriber)webSocketSession.getUserProperties().get("WILDFLY_SUBSCRIBER");
        String documentId = (String)webSocketSession.getUserProperties().get("DOCUMENT_ID");
        syncEngine.removeSubscriber((Subscriber)subscriber, documentId);
    }

    private PatchMessage<JsonPatchEdit> addSubscriber(Document<JsonNode> document, String clientId, Session session) {
        WildflySubscriber subscriber = new WildflySubscriber(clientId, session);
        return syncEngine.addSubscriber((Subscriber)subscriber, document);
    }

    private void patch(PatchMessage<JsonPatchEdit> patchMessage) {
        syncEngine.notifySubscribers(syncEngine.patch(patchMessage));
    }

    private void checkForReconnect(String documentId, String clientId, Session session) {
        if (SyncEndpoint.getOrDefault((Map)session.getUserProperties(), (Boolean)Boolean.FALSE) == Boolean.TRUE) {
            return;
        }
        logger.info("Reconnected client [" + clientId + "]. Adding as listener.");
        WildflySubscriber subscriber = new WildflySubscriber(clientId, session);
        syncEngine.connectSubscriber((Subscriber)subscriber, documentId);
    }

    private static Boolean getOrDefault(Map<String, Object> properties, Boolean defaultValue) {
        Boolean value = (Boolean)properties.get("DOC_ADD");
        return value != null ? value : defaultValue;
    }
}

