/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server.wildfly;

import javax.websocket.Session;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.server.Subscriber;
import org.jboss.aerogear.sync.server.wildfly.LoggingSendHandler;

public class WildflySubscriber
implements Subscriber<Session> {
    private final Session webSocketSession;
    private final String clientId;

    public WildflySubscriber(String clientId, Session webSocketSession) {
        this.clientId = clientId;
        this.webSocketSession = webSocketSession;
    }

    public String clientId() {
        return this.clientId;
    }

    public Session channel() {
        return this.webSocketSession;
    }

    public void patched(PatchMessage<?> patchMessage) {
        if (this.webSocketSession.isOpen()) {
            this.webSocketSession.getAsyncRemote().sendText(patchMessage.asJson(), LoggingSendHandler.INSTANCE);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscriber subscriber = (Subscriber)o;
        if (!this.clientId.equals(subscriber.clientId())) {
            return false;
        }
        return !this.webSocketSession.equals(subscriber.channel());
    }

    public int hashCode() {
        int result = this.clientId.hashCode();
        result = 31 * result + this.webSocketSession.hashCode();
        return result;
    }
}

