/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server.gcm;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.aerogear.sync.diffmatchpatch.JsonMapper;
import org.json.simple.JSONValue;

public final class GcmMessages {
    private GcmMessages() {
    }

    public static String createJsonMessage(String to, String messageId, String payload) {
        return GcmMessages.createJsonMessage(to, messageId, payload, null, null, null);
    }

    public static String createJsonMessage(String to, String messageId, String payload, String collapseKey, Long timeToLive, Boolean delayWhileIdle) {
        HashMap<String, Object> message = new HashMap<String, Object>();
        message.put("to", to);
        if (collapseKey != null) {
            message.put("collapse_key", collapseKey);
        }
        if (timeToLive != null) {
            message.put("time_to_live", timeToLive);
        }
        if (delayWhileIdle != null && delayWhileIdle.booleanValue()) {
            message.put("delay_while_idle", true);
        }
        message.put("message_id", messageId);
        message.put("data", GcmMessages.payloadToMap(payload));
        return JSONValue.toJSONString(message);
    }

    private static Map<String, String> payloadToMap(String payload) {
        HashMap<String, String> data = new HashMap<String, String>();
        JsonNode payloadJson = JsonMapper.asJsonNode((String)payload);
        Iterator fields = payloadJson.fields();
        while (fields.hasNext()) {
            Map.Entry field = (Map.Entry)fields.next();
            if (((JsonNode)field.getValue()).isValueNode()) {
                data.put((String)field.getKey(), ((JsonNode)field.getValue()).asText());
                continue;
            }
            data.put((String)field.getKey(), JsonMapper.toString((JsonNode)((JsonNode)field.getValue())));
        }
        return data;
    }
}

