/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test;

import com.jayway.restassured.response.Response;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.jboss.aerogear.test.Validate;

public class UnexpectedResponseException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final Response response;
    private final int actualStatusCode;
    private final int expectedStatusCode;

    public UnexpectedResponseException(Response response) {
        this(response, -1);
    }

    public UnexpectedResponseException(Response response, int expectedStatus) {
        this(response, response.statusCode(), expectedStatus);
    }

    public UnexpectedResponseException(Response response, int actualStatusCode, int expectedStatusCode) {
        super("Unexpected response status code: " + actualStatusCode + "! (expected: " + expectedStatusCode + ")");
        this.response = response;
        this.actualStatusCode = actualStatusCode;
        this.expectedStatusCode = expectedStatusCode;
    }

    public Response getResponse() {
        return this.response;
    }

    public int getActualStatusCode() {
        return this.actualStatusCode;
    }

    public int getExpectedStatusCode() {
        return this.expectedStatusCode;
    }

    public static void verifyStatusCode(int actualStatusCode, int expectedStatusCode) throws UnexpectedResponseException {
        if (actualStatusCode != expectedStatusCode) {
            throw new UnexpectedResponseException(null, actualStatusCode, expectedStatusCode);
        }
    }

    public static void verifyResponse(Response response, int expectedStatus) throws UnexpectedResponseException, NullPointerException {
        Validate.notNull(expectedStatus);
        if (response.statusCode() != expectedStatus) {
            throw new UnexpectedResponseException(response, expectedStatus);
        }
    }

    public static class Matcher
    extends TypeSafeMatcher<UnexpectedResponseException> {
        private int expectedResponseCode;
        private int foundResponseCode;

        private Matcher(int expectedResponseCode) {
            this.expectedResponseCode = expectedResponseCode;
        }

        protected boolean matchesSafely(UnexpectedResponseException e) {
            this.foundResponseCode = e.getActualStatusCode();
            return this.foundResponseCode == this.expectedResponseCode;
        }

        public void describeTo(Description description) {
            description.appendText("The found response code: ").appendValue((Object)this.foundResponseCode).appendText(" doesn't match expected code: ").appendValue((Object)this.expectedResponseCode);
        }

        public static Matcher expect(int expectedStatus) {
            return new Matcher(expectedStatus);
        }
    }
}

