/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.application;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.test.ContentTypes;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.AbstractUPSWorker;
import org.jboss.aerogear.test.api.application.PushApplicationBlueprint;
import org.jboss.aerogear.test.api.application.PushApplicationContext;
import org.jboss.aerogear.test.api.application.PushApplicationEditor;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.json.simple.JSONObject;

public class PushApplicationWorker
extends AbstractUPSWorker<PushApplication, String, PushApplicationBlueprint, PushApplicationEditor, Void, PushApplicationContext, PushApplicationWorker> {
    private String contentType = ContentTypes.json();

    private PushApplicationWorker() {
    }

    @Override
    public PushApplicationContext createContext(Session session, Void parent) {
        return new PushApplicationContext(this, session);
    }

    @Override
    public JSONObject marshall(PushApplication application) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)application.getName());
        jsonObject.put((Object)"description", (Object)application.getDescription());
        return jsonObject;
    }

    @Override
    public PushApplicationEditor demarshall(PushApplicationContext context, JsonPath jsonPath) {
        PushApplicationEditor application = new PushApplicationEditor(context);
        application.setName(jsonPath.getString("name"));
        application.setDescription(jsonPath.getString("description"));
        application.setPushApplicationID(jsonPath.getString("pushApplicationID"));
        application.setMasterSecret(jsonPath.getString("masterSecret"));
        application.setDeveloper(jsonPath.getString("developer"));
        return application;
    }

    @Override
    public List<PushApplicationEditor> create(PushApplicationContext context, Collection<? extends PushApplicationBlueprint> pushApplications) {
        ArrayList<PushApplicationEditor> registeredApplications = new ArrayList<PushApplicationEditor>();
        for (PushApplication pushApplication : pushApplications) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.contentType).header(Headers.acceptJson()).body((Object)this.marshall(pushApplication)).post("/rest/applications", new Object[0]);
            UnexpectedResponseException.verifyResponse(response, 201);
            registeredApplications.add(this.demarshall(context, response.jsonPath()));
        }
        return registeredApplications;
    }

    @Override
    public List<PushApplicationEditor> readAll(PushApplicationContext context) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(ContentTypes.json()).header(Headers.acceptJson()).get("/rest/applications", new Object[0]);
        UnexpectedResponseException.verifyResponse(response, 200);
        ArrayList<PushApplicationEditor> applications = new ArrayList<PushApplicationEditor>();
        JsonPath jsonPath = response.jsonPath();
        List items = jsonPath.getList("");
        for (int i = 0; i < items.size(); ++i) {
            jsonPath.setRoot("[" + i + "]");
            PushApplicationEditor pushApplication = this.demarshall(context, jsonPath);
            applications.add(pushApplication);
        }
        return applications;
    }

    @Override
    public PushApplicationEditor read(PushApplicationContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.contentType).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}", new Object[]{id});
        UnexpectedResponseException.verifyResponse(response, 200);
        return this.demarshall(context, response.jsonPath());
    }

    @Override
    public void update(PushApplicationContext context, Collection<? extends PushApplication> pushApplications) {
        for (PushApplication pushApplication : pushApplications) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.contentType).header(Headers.acceptJson()).body((Object)this.marshall(pushApplication)).put("/rest/applications/{pushApplicationID}", new Object[]{context.getEntityID(pushApplication)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public void deleteById(PushApplicationContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.contentType).header(Headers.acceptJson()).delete("/rest/applications/{pushApplicationID}", new Object[]{id});
        UnexpectedResponseException.verifyResponse(response, 204);
    }

    public void resetMasterSecret(PushApplicationContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.contentType).header(Headers.acceptJson()).body("[]").put("/rest/applications/{pushApplicationID}/reset", new Object[]{id});
        UnexpectedResponseException.verifyResponse(response, 200);
    }

    @Override
    public PushApplicationWorker contentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public static PushApplicationWorker worker() {
        return new PushApplicationWorker();
    }
}

