/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.installation;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import com.jayway.restassured.specification.RequestSpecification;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.AbstractUPSContext;
import org.jboss.aerogear.test.api.AbstractUPSWorker;
import org.jboss.aerogear.test.api.installation.InstallationBlueprint;
import org.jboss.aerogear.test.api.installation.InstallationContext;
import org.jboss.aerogear.test.api.installation.InstallationEditor;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public abstract class InstallationWorker<BLUEPRINT extends InstallationBlueprint<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, EDITOR extends InstallationEditor<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, PARENT extends Variant, CONTEXT extends InstallationContext<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, WORKER extends InstallationWorker<BLUEPRINT, EDITOR, PARENT, CONTEXT, WORKER>>
extends AbstractUPSWorker<Installation, String, BLUEPRINT, EDITOR, PARENT, CONTEXT, WORKER> {
    @Override
    public JSONObject marshall(Installation entity) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"deviceToken", (Object)entity.getDeviceToken());
        jsonObject.put((Object)"deviceType", (Object)entity.getDeviceType());
        jsonObject.put((Object)"operatingSystem", (Object)entity.getOperatingSystem());
        jsonObject.put((Object)"osVersion", (Object)entity.getOsVersion());
        jsonObject.put((Object)"alias", (Object)entity.getAlias());
        if (entity.getCategories() != null) {
            JSONArray categories = new JSONArray();
            for (String category : entity.getCategories()) {
                categories.add((Object)category);
            }
            jsonObject.put((Object)"categories", (Object)categories);
        }
        return jsonObject;
    }

    @Override
    public EDITOR demarshall(CONTEXT context, JsonPath jsonPath) {
        Object editor = ((InstallationContext)context).createEditor();
        editor.setId(jsonPath.getString("id"));
        editor.setPlatform(jsonPath.getString("platform"));
        editor.setEnabled(jsonPath.getBoolean("enabled"));
        editor.setOperatingSystem(jsonPath.getString("operatingSystem"));
        editor.setOsVersion(jsonPath.getString("osVersion"));
        editor.setAlias(jsonPath.getString("alias"));
        editor.setDeviceType(jsonPath.getString("deviceType"));
        editor.setDeviceToken(jsonPath.getString("deviceToken"));
        HashSet<String> categories = new HashSet<String>();
        List jsonCategories = jsonPath.getList("categories");
        if (jsonCategories != null) {
            for (String jsonCategory : jsonCategories) {
                categories.add(jsonCategory);
            }
        }
        editor.setCategories(categories);
        return editor;
    }

    @Override
    public List<EDITOR> create(CONTEXT context, Collection<? extends BLUEPRINT> blueprints) {
        ArrayList<EDITOR> editors = new ArrayList<EDITOR>();
        for (InstallationBlueprint blueprint : blueprints) {
            Response response = (Response)((AbstractUPSContext)context).getSession().given().contentType(this.getContentType()).auth().basic(((Variant)((AbstractUPSContext)context).getParent()).getVariantID(), ((Variant)((AbstractUPSContext)context).getParent()).getSecret()).header(Headers.acceptJson()).body((Object)this.marshall(blueprint)).post("/rest/registry/device", new Object[0]);
            UnexpectedResponseException.verifyResponse(response, 200);
            editors.add(this.demarshall(context, response.jsonPath()));
        }
        return editors;
    }

    public void unregister(CONTEXT context, Collection<? extends Installation> entities) {
        for (Installation installation : entities) {
            String token = installation.getDeviceToken();
            System.out.println("Installation token: " + token);
            token = URLEncoder.encode(token);
            System.out.println("Installation token encoded: " + token);
            token = URLEncoder.encode(token);
            Response response = (Response)((RequestSpecification)((AbstractUPSContext)context).getSession().given().log().all()).contentType(this.getContentType()).auth().basic(((Variant)((AbstractUPSContext)context).getParent()).getVariantID(), ((Variant)((AbstractUPSContext)context).getParent()).getSecret()).delete(URI.create("/rest/registry/device/" + token));
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public List<EDITOR> readAll(CONTEXT context) {
        Response response = (Response)((AbstractUPSContext)context).getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{variantID}/installations", new Object[]{((Variant)((AbstractUPSContext)context).getParent()).getVariantID()});
        UnexpectedResponseException.verifyResponse(response, 200);
        ArrayList<EDITOR> editors = new ArrayList<EDITOR>();
        JsonPath jsonPath = response.jsonPath();
        List items = jsonPath.getList("");
        for (int i = 0; i < items.size(); ++i) {
            jsonPath.setRoot("[" + i + "]");
            EDITOR editor = this.demarshall(context, jsonPath);
            editors.add(editor);
        }
        return editors;
    }

    @Override
    public EDITOR read(CONTEXT context, String id) {
        Response response = (Response)((AbstractUPSContext)context).getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{variantID}/installations/{installationID}", new Object[]{((Variant)((AbstractUPSContext)context).getParent()).getVariantID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
        return this.demarshall(context, response.jsonPath());
    }

    @Override
    public void update(CONTEXT context, Collection<? extends Installation> entities) {
        for (Installation installation : entities) {
            Response response = (Response)((AbstractUPSContext)context).getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(installation)).put("/rest/applications/{variantID}/installations/{installationID}", new Object[]{((Variant)((AbstractUPSContext)context).getParent()).getVariantID(), ((InstallationContext)context).getEntityID(installation)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public void deleteById(CONTEXT context, String id) {
        Response response = (Response)((AbstractUPSContext)context).getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).delete("/rest/applications/{variantID}/installations/{installationID}", new Object[]{((Variant)((AbstractUPSContext)context).getParent()).getVariantID(), id});
        UnexpectedResponseException.verifyResponse(response, 204);
    }
}

