/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.sender;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.AbstractSessionRequest;
import org.jboss.aerogear.unifiedpush.SenderClient;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;

public class SenderRequest
extends AbstractSessionRequest<SenderRequest> {
    public UnifiedMessageBlueprint message() {
        return new UnifiedMessageBlueprint();
    }

    public SenderRequest send(UnifiedMessage message) {
        SenderClient senderClient = new SenderClient.Builder(this.getSession().getBaseUrl().toExternalForm()).customTrustStore("setup/aerogear.truststore", null, "aerogear").build();
        final CountDownLatch latch = new CountDownLatch(1);
        final AtomicInteger statusCode = new AtomicInteger(-1);
        MessageResponseCallback callback = new MessageResponseCallback(){

            public void onComplete(int status) {
                statusCode.set(status);
                latch.countDown();
            }

            public void onError(Throwable throwable) {
                throw new RuntimeException(throwable);
            }
        };
        senderClient.send(message, callback);
        try {
            latch.await(5000L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        UnexpectedResponseException.verifyStatusCode(statusCode.get(), 200);
        return this;
    }

    public static SenderRequest request() {
        return new SenderRequest();
    }

    public class UnifiedMessageBlueprint {
        private final UnifiedMessage.Builder builder = new UnifiedMessage.Builder();

        public UnifiedMessageBlueprint pushApplication(PushApplication pushApplication) {
            return this.pushApplicationId(pushApplication.getPushApplicationID()).masterSecret(pushApplication.getMasterSecret());
        }

        public UnifiedMessageBlueprint pushApplicationId(String pushApplicationId) {
            this.builder.pushApplicationId(pushApplicationId);
            return this;
        }

        public UnifiedMessageBlueprint masterSecret(String masterSecret) {
            this.builder.masterSecret(masterSecret);
            return this;
        }

        public UnifiedMessageBlueprint aliases(String ... aliases) {
            return this.aliases(Arrays.asList(aliases));
        }

        public UnifiedMessageBlueprint aliases(List<String> aliases) {
            this.builder.aliases(aliases);
            return this;
        }

        public UnifiedMessageBlueprint aliasesOf(Installation ... installations) {
            return this.aliasesOf(Arrays.asList(installations));
        }

        public UnifiedMessageBlueprint aliasesOf(List<? extends Installation> installations) {
            ArrayList<String> aliases = new ArrayList<String>();
            for (Installation installation : installations) {
                aliases.add(installation.getAlias());
            }
            return this.aliases(aliases);
        }

        public UnifiedMessageBlueprint deviceTypes(String ... deviceTypes) {
            return this.deviceTypes(Arrays.asList(deviceTypes));
        }

        public UnifiedMessageBlueprint deviceTypes(List<String> deviceTypes) {
            this.builder.deviceType(deviceTypes);
            return this;
        }

        public UnifiedMessageBlueprint deviceTypesOf(Installation ... installations) {
            return this.deviceTypesOf(Arrays.asList(installations));
        }

        public UnifiedMessageBlueprint deviceTypesOf(List<? extends Installation> installations) {
            ArrayList<String> deviceTypes = new ArrayList<String>();
            for (Installation installation : installations) {
                deviceTypes.add(installation.getDeviceType());
            }
            return this.deviceTypes(deviceTypes);
        }

        public UnifiedMessageBlueprint categories(String ... categories) {
            this.builder.categories(categories);
            return this;
        }

        public UnifiedMessageBlueprint categories(Set<String> categories) {
            this.builder.categories(categories);
            return this;
        }

        public UnifiedMessageBlueprint categoriesOf(Installation ... installations) {
            return this.categoriesOf(Arrays.asList(installations));
        }

        public UnifiedMessageBlueprint categoriesOf(List<? extends Installation> installations) {
            HashSet<String> categories = new HashSet<String>();
            for (Installation installation : installations) {
                categories.addAll(installation.getCategories());
            }
            return this.categories(categories);
        }

        public UnifiedMessageBlueprint variantIDs(String ... variants) {
            return this.variantIDs(Arrays.asList(variants));
        }

        public UnifiedMessageBlueprint variantIDs(List<String> variants) {
            this.builder.variants(variants);
            return this;
        }

        public UnifiedMessageBlueprint variants(Variant ... variants) {
            return this.variants(Arrays.asList(variants));
        }

        public UnifiedMessageBlueprint variants(List<? extends Variant> variants) {
            ArrayList<String> variantIDs = new ArrayList<String>();
            for (Variant variant : variants) {
                variantIDs.add(variant.getVariantID());
            }
            return this.variantIDs(variantIDs);
        }

        public UnifiedMessageBlueprint attribute(String key, String value) {
            this.builder.attribute(key, value);
            return this;
        }

        public UnifiedMessageBlueprint alert(String message) {
            this.builder.alert(message);
            return this;
        }

        public UnifiedMessageBlueprint sound(String sound) {
            this.builder.sound(sound);
            return this;
        }

        public UnifiedMessageBlueprint badge(String badge) {
            this.builder.badge(badge);
            return this;
        }

        public UnifiedMessageBlueprint contentAvailable() {
            this.builder.contentAvailable();
            return this;
        }

        public UnifiedMessageBlueprint simplePush(String version) {
            this.builder.simplePush(version);
            return this;
        }

        public UnifiedMessageBlueprint timeToLive(int seconds) {
            this.builder.timeToLive(seconds);
            return this;
        }

        public SenderRequest send() {
            SenderRequest.this.send(this.builder.build());
            return SenderRequest.this;
        }
    }
}

