/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.variant.ios;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.test.ContentTypes;
import org.jboss.aerogear.test.FileUtils;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.variant.VariantWorker;
import org.jboss.aerogear.test.api.variant.ios.iOSVariantBlueprint;
import org.jboss.aerogear.test.api.variant.ios.iOSVariantContext;
import org.jboss.aerogear.test.api.variant.ios.iOSVariantEditor;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.iOSVariant;
import org.json.simple.JSONObject;

public class iOSVariantWorker
extends VariantWorker<iOSVariant, String, iOSVariantBlueprint, iOSVariantEditor, PushApplication, iOSVariantContext, iOSVariantWorker> {
    private byte[] defaultCertificate;
    private String defaultPassphrase;

    private iOSVariantWorker() {
    }

    @Override
    public iOSVariantContext createContext(Session session, PushApplication parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null!");
        }
        return new iOSVariantContext(this, parent, session);
    }

    @Override
    public JSONObject marshall(iOSVariant entity) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)entity.getName());
        jsonObject.put((Object)"description", (Object)entity.getDescription());
        jsonObject.put((Object)"production", (Object)entity.isProduction());
        return jsonObject;
    }

    @Override
    public iOSVariantEditor demarshall(iOSVariantContext context, JsonPath jsonPath) {
        iOSVariantEditor editor = new iOSVariantEditor(context);
        editor.setName(jsonPath.getString("name"));
        editor.setDescription(jsonPath.getString("description"));
        editor.setVariantID(jsonPath.getString("variantID"));
        editor.setSecret(jsonPath.getString("secret"));
        editor.setDeveloper(jsonPath.getString("developer"));
        editor.setProduction(jsonPath.getBoolean("production"));
        editor.setId(jsonPath.getString("id"));
        editor.setPassphrase(jsonPath.getString("passphrase"));
        return editor;
    }

    @Override
    public List<iOSVariantEditor> create(iOSVariantContext context, Collection<? extends iOSVariantBlueprint> blueprints) {
        ArrayList<iOSVariantEditor> editors = new ArrayList<iOSVariantEditor>();
        for (iOSVariantBlueprint iOSVariantBlueprint2 : blueprints) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(ContentTypes.multipartFormData()).header(Headers.acceptJson()).multiPart("certificate", "certificate.p12", iOSVariantBlueprint2.getCertificate(), ContentTypes.octetStream()).multiPart("production", String.valueOf(iOSVariantBlueprint2.isProduction())).multiPart("passphrase", iOSVariantBlueprint2.getPassphrase()).multiPart("name", iOSVariantBlueprint2.getName()).multiPart("description", iOSVariantBlueprint2.getDescription()).post("/rest/applications/{pushApplicationID}/ios", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
            UnexpectedResponseException.verifyResponse(response, 201);
            editors.add(this.demarshall(context, response.jsonPath()));
        }
        return editors;
    }

    @Override
    public List<iOSVariantEditor> readAll(iOSVariantContext context) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/ios", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
        UnexpectedResponseException.verifyResponse(response, 200);
        ArrayList<iOSVariantEditor> editors = new ArrayList<iOSVariantEditor>();
        JsonPath jsonPath = response.jsonPath();
        List items = jsonPath.getList("");
        for (int i = 0; i < items.size(); ++i) {
            jsonPath.setRoot("[" + i + "]");
            iOSVariantEditor editor = this.demarshall(context, jsonPath);
            editors.add(editor);
        }
        return editors;
    }

    @Override
    public iOSVariantEditor read(iOSVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/ios/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
        return this.demarshall(context, response.jsonPath());
    }

    @Override
    public void update(iOSVariantContext context, Collection<? extends iOSVariant> entities) {
        for (iOSVariant iOSVariant2 : entities) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(ContentTypes.multipartFormData()).header(Headers.acceptJson()).multiPart("certificate", "certificate.p12", iOSVariant2.getCertificate(), ContentTypes.octetStream()).multiPart("production", String.valueOf(iOSVariant2.isProduction())).multiPart("passphrase", iOSVariant2.getPassphrase()).multiPart("name", iOSVariant2.getName()).multiPart("description", iOSVariant2.getDescription()).put("/rest/applications/{pushApplicationID}/ios/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), context.getEntityID(iOSVariant2)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    public void updatePatch(iOSVariantContext context, Collection<? extends iOSVariant> entities) {
        for (iOSVariant iOSVariant2 : entities) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(iOSVariant2)).patch("/rest/applications/{pushApplicationID}/ios/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), context.getEntityID(iOSVariant2)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public void deleteById(iOSVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).delete("/rest/applications/{pushApplicationID}/ios/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 204);
    }

    @Override
    public void resetSecret(iOSVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body("[]").put("/rest/applications/{pushApplicationID}/ios/{variantID}/reset", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
    }

    public byte[] getDefaultCertificate() {
        return this.defaultCertificate;
    }

    public iOSVariantWorker defaultCertificate(String defaultCertificate) {
        return this.defaultCertificate(new File(defaultCertificate));
    }

    public iOSVariantWorker defaultCertificate(File defaultCertificate) {
        return this.defaultCertificate(FileUtils.toByteArray(defaultCertificate));
    }

    public iOSVariantWorker defaultCertificate(byte[] defaultCertificate) {
        this.defaultCertificate = defaultCertificate;
        return this;
    }

    public String getDefaultPassphrase() {
        return this.defaultPassphrase;
    }

    public iOSVariantWorker defaultPassphrase(String defaultPassphrase) {
        this.defaultPassphrase = defaultPassphrase;
        return this;
    }

    public static iOSVariantWorker worker() {
        return new iOSVariantWorker();
    }
}

