/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.MessageFormat;

public class FileUtils {
    private FileUtils() {
    }

    public static byte[] toByteArray(File file) {
        FileInputStream inputStream = null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(file);
            int read = 0;
            byte[] buffer = new byte[4096];
            while ((read = inputStream.read(buffer)) != -1) {
                outputStream.write(buffer, 0, read);
            }
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException(MessageFormat.format("File {0} does not exist!", file.getName()), e);
        }
        catch (IOException e) {
            throw new IllegalStateException(MessageFormat.format("Couldn't read file {0}!", file.getName()), e);
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

