/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test;

import com.jayway.restassured.RestAssured;
import com.jayway.restassured.response.Header;
import com.jayway.restassured.specification.RequestSpecification;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.keycloak.representations.AccessTokenResponse;

public class Session {
    private URL baseUrl;
    private String baseUri;
    private int port;
    private String basePath;
    private AccessTokenResponse accessTokenResponse;
    private Map<String, ?> cookies;
    private boolean invalid;

    public Session(URL baseUrl, AccessTokenResponse accessTokenResponse) {
        this.baseUrl = baseUrl;
        this.baseUri = baseUrl.getProtocol() + "://" + baseUrl.getHost();
        this.port = baseUrl.getPort() == -1 ? ("https".equals(baseUrl.getProtocol()) ? 443 : 80) : baseUrl.getPort();
        this.basePath = baseUrl.getPath();
        this.accessTokenResponse = accessTokenResponse;
        this.cookies = new HashMap();
        this.invalid = false;
    }

    public Session(String baseUrl, AccessTokenResponse accessTokenResponse) {
        this(UrlUtils.from(baseUrl), accessTokenResponse);
    }

    public RequestSpecification givenAuthorized() {
        if (this.accessTokenResponse.getToken() == null) {
            return this.given();
        }
        return this.given().header(this.getAuthorization());
    }

    public RequestSpecification given() {
        RestAssured.baseURI = this.baseUri;
        RestAssured.port = this.port;
        RestAssured.basePath = this.basePath;
        return RestAssured.given().redirects().follow(false).cookies(this.cookies);
    }

    public Map<String, ?> getCookies() {
        return this.cookies;
    }

    public Header getAuthorization() {
        String accessToken = "";
        if (this.accessTokenResponse.getToken() != null) {
            accessToken = this.accessTokenResponse.getToken();
        }
        return new Header("Authorization", "Bearer " + accessToken);
    }

    public URL getBaseUrl() {
        return this.baseUrl;
    }

    public boolean isValid() {
        return !this.invalid;
    }

    public static Session newSession(String url) {
        return new Session(url, new AccessTokenResponse());
    }

    public Session invalidate() {
        this.invalid = true;
        this.cookies = new HashMap();
        this.baseUrl = null;
        this.accessTokenResponse = new AccessTokenResponse();
        return this;
    }

    private static final class UrlUtils {
        private UrlUtils() {
        }

        static final URL from(String url) throws IllegalArgumentException {
            try {
                return new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException("Unable to convert " + url + "to URL object");
            }
        }
    }
}

