/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.variant.chromepackagedapp;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.variant.VariantWorker;
import org.jboss.aerogear.test.api.variant.chromepackagedapp.ChromePackagedAppVariantBlueprint;
import org.jboss.aerogear.test.api.variant.chromepackagedapp.ChromePackagedAppVariantContext;
import org.jboss.aerogear.test.api.variant.chromepackagedapp.ChromePackagedAppVariantEditor;
import org.jboss.aerogear.unifiedpush.api.ChromePackagedAppVariant;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.json.simple.JSONObject;

public class ChromePackagedAppVariantWorker
extends VariantWorker<ChromePackagedAppVariant, String, ChromePackagedAppVariantBlueprint, ChromePackagedAppVariantEditor, PushApplication, ChromePackagedAppVariantContext, ChromePackagedAppVariantWorker> {
    private ChromePackagedAppVariantWorker() {
    }

    @Override
    public ChromePackagedAppVariantContext createContext(Session session, PushApplication parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null!");
        }
        return new ChromePackagedAppVariantContext(this, parent, session);
    }

    @Override
    public JSONObject marshall(ChromePackagedAppVariant entity) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)entity.getName());
        jsonObject.put((Object)"description", (Object)entity.getDescription());
        jsonObject.put((Object)"clientId", (Object)entity.getClientId());
        jsonObject.put((Object)"clientSecret", (Object)entity.getClientSecret());
        jsonObject.put((Object)"refreshToken", (Object)entity.getRefreshToken());
        return jsonObject;
    }

    @Override
    public ChromePackagedAppVariantEditor demarshall(ChromePackagedAppVariantContext context, JsonPath jsonPath) {
        ChromePackagedAppVariantEditor editor = new ChromePackagedAppVariantEditor(context);
        editor.setName(jsonPath.getString("name"));
        editor.setDescription(jsonPath.getString("description"));
        editor.setVariantID(jsonPath.getString("variantID"));
        editor.setSecret(jsonPath.getString("secret"));
        editor.setDeveloper(jsonPath.getString("developer"));
        editor.setId(jsonPath.getString("id"));
        editor.setClientId(jsonPath.getString("clientId"));
        editor.setClientSecret(jsonPath.getString("clientSecret"));
        editor.setRefreshToken(jsonPath.getString("refreshToken"));
        return editor;
    }

    @Override
    public List<ChromePackagedAppVariantEditor> create(ChromePackagedAppVariantContext context, Collection<? extends ChromePackagedAppVariantBlueprint> blueprints) {
        ArrayList<ChromePackagedAppVariantEditor> editors = new ArrayList<ChromePackagedAppVariantEditor>();
        for (ChromePackagedAppVariantBlueprint chromePackagedAppVariantBlueprint : blueprints) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(chromePackagedAppVariantBlueprint)).post("/rest/applications/{pushApplicationID}/chrome", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
            UnexpectedResponseException.verifyResponse(response, 201);
            editors.add(this.demarshall(context, response.jsonPath()));
        }
        return editors;
    }

    @Override
    public List<ChromePackagedAppVariantEditor> readAll(ChromePackagedAppVariantContext context) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/chrome", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
        UnexpectedResponseException.verifyResponse(response, 200);
        ArrayList<ChromePackagedAppVariantEditor> editors = new ArrayList<ChromePackagedAppVariantEditor>();
        JsonPath jsonPath = response.jsonPath();
        List items = jsonPath.getList("");
        for (int i = 0; i < items.size(); ++i) {
            jsonPath.setRoot("[" + i + "]");
            ChromePackagedAppVariantEditor editor = this.demarshall(context, jsonPath);
            editors.add(editor);
        }
        return editors;
    }

    @Override
    public ChromePackagedAppVariantEditor read(ChromePackagedAppVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/chrome/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
        return this.demarshall(context, response.jsonPath());
    }

    @Override
    public void update(ChromePackagedAppVariantContext context, Collection<? extends ChromePackagedAppVariant> entities) {
        for (ChromePackagedAppVariant chromePackagedAppVariant : entities) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(chromePackagedAppVariant)).put("/rest/applications/{pushApplicationID}/chrome/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), context.getEntityID(chromePackagedAppVariant)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public void deleteById(ChromePackagedAppVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).delete("/rest/applications/{pushApplicationID}/chrome/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 204);
    }

    @Override
    public void resetSecret(ChromePackagedAppVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body("[]").put("/rest/applications/{pushApplicationID}/chrome/{variantID}/reset", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
    }

    public static ChromePackagedAppVariantWorker worker() {
        return new ChromePackagedAppVariantWorker();
    }
}

