/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.variant.simplepush;

import com.jayway.restassured.path.json.JsonPath;
import com.jayway.restassured.response.Response;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.variant.VariantWorker;
import org.jboss.aerogear.test.api.variant.simplepush.SimplePushVariantBlueprint;
import org.jboss.aerogear.test.api.variant.simplepush.SimplePushVariantContext;
import org.jboss.aerogear.test.api.variant.simplepush.SimplePushVariantEditor;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.api.SimplePushVariant;
import org.json.simple.JSONObject;

public class SimplePushVariantWorker
extends VariantWorker<SimplePushVariant, String, SimplePushVariantBlueprint, SimplePushVariantEditor, PushApplication, SimplePushVariantContext, SimplePushVariantWorker> {
    private SimplePushVariantWorker() {
    }

    @Override
    public SimplePushVariantContext createContext(Session session, PushApplication parent) {
        if (parent == null) {
            throw new IllegalArgumentException("Parent cannot be null!");
        }
        return new SimplePushVariantContext(this, parent, session);
    }

    @Override
    public JSONObject marshall(SimplePushVariant entity) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put((Object)"name", (Object)entity.getName());
        jsonObject.put((Object)"description", (Object)entity.getDescription());
        return jsonObject;
    }

    @Override
    public SimplePushVariantEditor demarshall(SimplePushVariantContext context, JsonPath jsonPath) {
        SimplePushVariantEditor editor = new SimplePushVariantEditor(context);
        editor.setName(jsonPath.getString("name"));
        editor.setDescription(jsonPath.getString("description"));
        editor.setVariantID(jsonPath.getString("variantID"));
        editor.setSecret(jsonPath.getString("secret"));
        editor.setDeveloper(jsonPath.getString("developer"));
        editor.setId(jsonPath.getString("id"));
        return editor;
    }

    @Override
    public List<SimplePushVariantEditor> create(SimplePushVariantContext context, Collection<? extends SimplePushVariantBlueprint> blueprints) {
        ArrayList<SimplePushVariantEditor> editors = new ArrayList<SimplePushVariantEditor>();
        for (SimplePushVariantBlueprint simplePushVariantBlueprint : blueprints) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(simplePushVariantBlueprint)).post("/rest/applications/{pushApplicationID}/simplePush", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
            UnexpectedResponseException.verifyResponse(response, 201);
            editors.add(this.demarshall(context, response.jsonPath()));
        }
        return editors;
    }

    @Override
    public List<SimplePushVariantEditor> readAll(SimplePushVariantContext context) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/simplePush", new Object[]{((PushApplication)context.getParent()).getPushApplicationID()});
        UnexpectedResponseException.verifyResponse(response, 200);
        ArrayList<SimplePushVariantEditor> editors = new ArrayList<SimplePushVariantEditor>();
        JsonPath jsonPath = response.jsonPath();
        List items = jsonPath.getList("");
        for (int i = 0; i < items.size(); ++i) {
            jsonPath.setRoot("[" + i + "]");
            SimplePushVariantEditor editor = this.demarshall(context, jsonPath);
            editors.add(editor);
        }
        return editors;
    }

    @Override
    public SimplePushVariantEditor read(SimplePushVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).get("/rest/applications/{pushApplicationID}/simplePush/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
        return this.demarshall(context, response.jsonPath());
    }

    @Override
    public void update(SimplePushVariantContext context, Collection<? extends SimplePushVariant> entities) {
        for (SimplePushVariant simplePushVariant : entities) {
            Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body((Object)this.marshall(simplePushVariant)).put("/rest/applications/{pushApplicationID}/simplePush/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), context.getEntityID(simplePushVariant)});
            UnexpectedResponseException.verifyResponse(response, 204);
        }
    }

    @Override
    public void deleteById(SimplePushVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).delete("/rest/applications/{pushApplicationID}/simplePush/{variantID}", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 204);
    }

    @Override
    public void resetSecret(SimplePushVariantContext context, String id) {
        Response response = (Response)context.getSession().givenAuthorized().contentType(this.getContentType()).header(Headers.acceptJson()).body("[]").put("/rest/applications/{pushApplicationID}/simplePush/{variantID}/reset", new Object[]{((PushApplication)context.getParent()).getPushApplicationID(), id});
        UnexpectedResponseException.verifyResponse(response, 200);
    }

    public static SimplePushVariantWorker worker() {
        return new SimplePushVariantWorker();
    }
}

