/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.test.Helper;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.api.BlueprintList;
import org.jboss.aerogear.test.api.UPSContext;
import org.jboss.aerogear.test.api.UPSWorker;

public abstract class AbstractUPSContext<ENTITY, ENTITY_ID, BLUEPRINT extends ENTITY, EDITOR extends ENTITY, PARENT, WORKER extends UPSWorker<ENTITY, ENTITY_ID, BLUEPRINT, EDITOR, PARENT, CONTEXT, WORKER>, CONTEXT extends UPSContext<ENTITY, ENTITY_ID, BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>>
implements UPSContext<ENTITY, ENTITY_ID, BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT> {
    public static final int DEFAULT_RANDOM_STRING_LENGTH = 32;
    private final WORKER worker;
    private final PARENT parent;
    private final Session session;
    private final Map<ENTITY_ID, EDITOR> editors;

    public AbstractUPSContext(WORKER worker, PARENT parent, Session session) {
        this.worker = worker;
        this.parent = parent;
        this.session = session;
        this.editors = new HashMap<ENTITY_ID, EDITOR>();
    }

    @Override
    public List<ENTITY> detachEntities() {
        ArrayList<EDITOR> entities = new ArrayList<EDITOR>();
        entities.addAll(this.editors.values());
        return entities;
    }

    @Override
    public ENTITY detachEntity() throws IllegalStateException {
        if (this.editors.size() != 1) {
            throw new IllegalStateException(MessageFormat.format("There has to be exactly one entity in the context to detach single entity! There were {0}", this.editors.size()));
        }
        return (ENTITY)this.editors.values().iterator().next();
    }

    @Override
    public ENTITY detachEntity(ENTITY_ID id) {
        return (ENTITY)this.retrieveOrThrow(id);
    }

    @Override
    public CONTEXT find(ENTITY_ID id) {
        Object editor = this.getWorker().read(this.castInstance(), id);
        this.store(editor);
        return this.castInstance();
    }

    @Override
    public CONTEXT findAll() {
        this.clear();
        List editors = this.getWorker().readAll(this.castInstance());
        this.store((EDITOR)editors);
        return this.castInstance();
    }

    @Override
    public BlueprintList<ENTITY, ENTITY_ID, BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT> generate(int count) {
        BlueprintList list = new BlueprintList(this.castInstance());
        for (int i = 0; i < count; ++i) {
            list.add(this.generate());
        }
        return list;
    }

    @Override
    public EDITOR edit(ENTITY_ID id) {
        if (!this.contains(id)) {
            this.find(id);
        }
        return this.retrieve(id);
    }

    @Override
    public CONTEXT persist(BLUEPRINT blueprint) {
        return this.persist((Collection<? extends BLUEPRINT>)Collections.singletonList(blueprint));
    }

    @Override
    public CONTEXT persist(Collection<? extends BLUEPRINT> blueprints) {
        List editors = this.getWorker().create(this.castInstance(), blueprints);
        this.store((EDITOR)editors);
        return this.castInstance();
    }

    @Override
    public CONTEXT merge(ENTITY entity) {
        return this.merge((Collection<? extends ENTITY>)Collections.singletonList(entity));
    }

    @Override
    public CONTEXT merge(Collection<? extends ENTITY> entities) {
        this.getWorker().update(this.castInstance(), entities);
        return this.castInstance();
    }

    @Override
    public CONTEXT removeAll() {
        this.getWorker().delete(this.castInstance(), this.editors.values());
        this.editors.clear();
        return this.castInstance();
    }

    @Override
    public CONTEXT removeById(ENTITY_ID id) {
        this.getWorker().deleteById(this.castInstance(), id);
        return this.castInstance();
    }

    @Override
    public CONTEXT remove(ENTITY entity) {
        return this.remove((Collection<? extends ENTITY>)Collections.singletonList(entity));
    }

    @Override
    public CONTEXT remove(Collection<? extends ENTITY> entities) {
        this.getWorker().delete(this.castInstance(), entities);
        for (ENTITY entity : entities) {
            this.localRemove(this.getEntityID(entity));
        }
        return this.castInstance();
    }

    @Override
    public PARENT getParent() {
        return this.parent;
    }

    @Override
    public WORKER getWorker() {
        return this.worker;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    protected void store(List<EDITOR> editors) {
        for (EDITOR editor : editors) {
            this.store(editor);
        }
    }

    protected void store(Map<ENTITY_ID, EDITOR> editors) {
        this.editors.putAll(editors);
    }

    protected void store(EDITOR editor) {
        this.store(this.getEntityID(editor), editor);
    }

    protected void store(ENTITY_ID id, EDITOR editor) {
        this.editors.put(id, editor);
    }

    protected void localRemove(ENTITY_ID id) {
        this.editors.remove(id);
    }

    protected EDITOR retrieveOrThrow(ENTITY_ID id) {
        if (!this.contains(id)) {
            throw new IllegalStateException(MessageFormat.format("Entity with id {0} has to be loaded before detaching!", id));
        }
        return this.editors.get(id);
    }

    protected EDITOR retrieve(ENTITY_ID id) {
        if (!this.contains(id)) {
            this.find(id);
        }
        return this.editors.get(id);
    }

    protected Map<ENTITY_ID, EDITOR> getEditors() {
        return this.editors;
    }

    protected boolean contains(ENTITY_ID id) {
        return this.editors.containsKey(id);
    }

    protected void clear() {
        this.editors.clear();
    }

    protected String randomString() {
        return this.randomStringOfLength(32);
    }

    protected String randomStringOfLength(int length) {
        return Helper.randomStringOfLength(length);
    }

    protected abstract CONTEXT castInstance();
}

