/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.auth;

import com.jayway.restassured.response.Response;
import java.io.IOException;
import java.net.URI;
import org.jboss.aerogear.test.Headers;
import org.jboss.aerogear.test.Session;
import org.jboss.aerogear.test.UnexpectedResponseException;
import org.jboss.aerogear.test.api.auth.AbstractAuthRequest;
import org.keycloak.representations.AccessTokenResponse;
import org.keycloak.util.JsonSerialization;
import org.keycloak.util.KeycloakUriBuilder;

public class LoginRequest
extends AbstractAuthRequest<LoginRequest> {
    private String username;
    private String password;

    public LoginRequest username(String username) {
        this.username = username;
        return this;
    }

    public LoginRequest password(String password) {
        this.password = password;
        return this;
    }

    public Session login() {
        URI authServerEndpointUri = KeycloakUriBuilder.fromUri((String)this.getAuthServerUrl().toExternalForm()).path("/realms/{realm-name}/tokens/grants/access").build(new Object[]{"aerogear"});
        Session session = Session.newSession(authServerEndpointUri.toString());
        Response response = (Response)session.given().header(Headers.acceptJson()).formParam("username", new Object[]{this.username}).formParam("password", new Object[]{this.password}).formParam("client_id", new Object[]{"integration-tests"}).post();
        if (response.statusCode() == 200) {
            try {
                AccessTokenResponse tokenResponse = (AccessTokenResponse)JsonSerialization.readValue((String)response.asString(), AccessTokenResponse.class);
                return new Session(this.getUnifiedPushServerUrl(), tokenResponse);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new UnexpectedResponseException(response, 200);
    }

    public static LoginRequest request() {
        return new LoginRequest();
    }
}

