/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.api.installation;

import java.util.Arrays;
import java.util.HashSet;
import org.jboss.aerogear.test.api.installation.InstallationBlueprint;
import org.jboss.aerogear.test.api.installation.InstallationContext;
import org.jboss.aerogear.test.api.installation.InstallationEditor;
import org.jboss.aerogear.test.api.installation.InstallationWorker;
import org.jboss.aerogear.test.api.installation.Tokens;
import org.jboss.aerogear.unifiedpush.api.Category;
import org.jboss.aerogear.unifiedpush.api.Installation;
import org.jboss.aerogear.unifiedpush.api.Variant;

public abstract class InstallationExtension<BLUEPRINT extends InstallationBlueprint<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, EDITOR extends InstallationEditor<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, PARENT extends Variant, WORKER extends InstallationWorker<BLUEPRINT, EDITOR, PARENT, CONTEXT, WORKER>, CONTEXT extends InstallationContext<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT>, EXTENSION extends InstallationExtension<BLUEPRINT, EDITOR, PARENT, WORKER, CONTEXT, EXTENSION>>
extends Installation {
    private static final long serialVersionUID = 1L;
    protected final CONTEXT context;

    public InstallationExtension(CONTEXT context) {
        this.context = context;
    }

    public EXTENSION enabled(boolean enabled) {
        this.setEnabled(enabled);
        return this.castInstance();
    }

    public EXTENSION deviceToken(String deviceToken) {
        this.setDeviceToken(deviceToken);
        return this.castInstance();
    }

    public boolean isTokenInvalid() {
        return this.getDeviceToken().startsWith(Tokens.TOKEN_INVALIDATION_PREFIX);
    }

    public EXTENSION invalidateToken() {
        if (!this.isTokenInvalid()) {
            this.setDeviceToken(Tokens.TOKEN_INVALIDATION_PREFIX + this.getDeviceToken());
        }
        return this.castInstance();
    }

    public EXTENSION deviceType(String deviceType) {
        this.setDeviceType(deviceType);
        return this.castInstance();
    }

    public EXTENSION operatingSystem(String operatingSystem) {
        this.setOperatingSystem(operatingSystem);
        return this.castInstance();
    }

    public EXTENSION osVersion(String osVersion) {
        this.setOsVersion(osVersion);
        return this.castInstance();
    }

    public EXTENSION alias(String alias) {
        this.setAlias(alias);
        return this.castInstance();
    }

    public EXTENSION categories(String ... categoryNames) {
        Category[] categories = new Category[categoryNames.length];
        for (int i = 0; i < categoryNames.length; ++i) {
            categories[i] = new Category(categoryNames[i]);
        }
        return this.categories(categories);
    }

    public EXTENSION categories(Category ... categories) {
        HashSet<Category> categorySet = new HashSet<Category>(Arrays.asList(categories));
        this.setCategories(categorySet);
        return this.castInstance();
    }

    public EXTENSION platform(String platform) {
        this.setPlatform(platform);
        return this.castInstance();
    }

    public EXTENSION generateMissingProperties() {
        return this.castInstance();
    }

    private EXTENSION castInstance() {
        return (EXTENSION)((Object)this);
    }
}

