/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.jboss.aerogear.test.container.manager.ManagedContainerConfiguration;
import org.jboss.aerogear.test.container.manager.ManagementClient;
import org.jboss.aerogear.test.container.manager.api.ContainerManager;
import org.jboss.aerogear.test.container.manager.api.ContainerManagerException;
import org.jboss.as.controller.client.ModelControllerClient;

public class JBossManager
implements ContainerManager {
    private static final Logger log = Logger.getLogger(JBossManager.class.getName());
    static final String TEMP_CONTAINER_DIRECTORY = "arquillian-temp-container";
    private static final String CONFIG_PATH = "/standalone/configuration/";
    static final String CONFIG_DIR = "configuration";
    static final String SERVER_BASE_DIR = "standalone";
    static final String LOG_DIR = "log";
    static final String DATA_DIR = "data";
    private Thread shutdownThread;
    private Process process;
    private ManagementClient client;
    private final ManagedContainerConfiguration configuration;

    public JBossManager() {
        this(new ManagedContainerConfiguration());
    }

    public JBossManager(ManagedContainerConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void start() throws ContainerManagerException {
        if (this.configuration.getUsername() != null) {
            Authentication.username = this.configuration.getUsername();
            Authentication.password = this.configuration.getPassword();
        }
        ModelControllerClient modelControllerClient = null;
        try {
            modelControllerClient = ModelControllerClient.Factory.create((String)this.configuration.getManagementAddress(), (int)this.configuration.getManagementPort(), (CallbackHandler)Authentication.getCallbackHandler());
        }
        catch (UnknownHostException e) {
            throw new ContainerManagerException(e);
        }
        this.client = new ManagementClient(modelControllerClient, this.configuration.getManagementAddress(), this.configuration.getManagementPort());
        try {
            this.startInternal();
        }
        catch (RuntimeException e) {
            this.safeCloseClient();
            throw new ContainerManagerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() throws ContainerManagerException {
        try {
            this.stopInternal();
        }
        finally {
            this.safeCloseClient();
        }
    }

    private void startInternal() {
        if (this.isServerRunning()) {
            if (this.configuration.isAllowConnectingToRunningServer()) {
                return;
            }
            this.failDueToRunning();
        }
        try {
            File modulesDir;
            String jbossHomeDir = this.configuration.getJbossHome();
            String modulesPath = this.configuration.getModulePath();
            if (modulesPath == null || modulesPath.isEmpty()) {
                modulesPath = jbossHomeDir + File.separatorChar + "modules";
            }
            if (!(modulesDir = new File(modulesPath)).isDirectory()) {
                throw new IllegalStateException("Cannot find: " + modulesDir);
            }
            String bundlesPath = modulesDir.getParent() + File.separator + "bundles";
            File bundlesDir = new File(bundlesPath);
            if (!bundlesDir.isDirectory()) {
                throw new IllegalStateException("Cannot find: " + bundlesDir);
            }
            String additionalJavaOpts = this.configuration.getJavaVmArguments();
            File modulesJar = new File(jbossHomeDir + File.separatorChar + "jboss-modules.jar");
            if (!modulesJar.exists()) {
                throw new IllegalStateException("Cannot find: " + modulesJar);
            }
            ArrayList<String> cmd = new ArrayList<String>();
            String javaExec = this.configuration.getJavaHome() + File.separatorChar + "bin" + File.separatorChar + "java";
            if (this.configuration.getJavaHome().contains(" ")) {
                javaExec = "\"" + javaExec + "\"";
            }
            cmd.add(javaExec);
            if (additionalJavaOpts != null) {
                for (String opt : additionalJavaOpts.split("\\s+")) {
                    cmd.add(opt);
                }
            }
            if (this.configuration.isEnableAssertions()) {
                cmd.add("-ea");
            }
            cmd.add("-Djboss.home.dir=" + jbossHomeDir);
            cmd.add("-Dorg.jboss.boot.log.file=" + jbossHomeDir + "/standalone/log/boot.log");
            cmd.add("-Dlogging.configuration=file:" + jbossHomeDir + CONFIG_PATH + "logging.properties");
            cmd.add("-Djboss.modules.dir=" + modulesDir.getCanonicalPath());
            cmd.add("-Djboss.bundles.dir=" + bundlesDir.getCanonicalPath());
            cmd.add("-jar");
            cmd.add(modulesJar.getAbsolutePath());
            cmd.add("-mp");
            cmd.add(modulesPath);
            cmd.add("-jaxpmodule");
            cmd.add("javax.xml.jaxp-provider");
            cmd.add("org.jboss.as.standalone");
            cmd.add("-server-config");
            cmd.add(this.configuration.getServerConfig());
            log.info("Starting container with: " + ((Object)cmd).toString());
            ProcessBuilder processBuilder = new ProcessBuilder(cmd);
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            long startupTimeout = this.configuration.getStartupTimeoutInSeconds();
            long timeout = startupTimeout * 1000L;
            boolean serverAvailable = false;
            long sleep = 1000L;
            while (timeout > 0L && !serverAvailable) {
                serverAvailable = this.getManagementClient().isServerInRunningState();
                if (serverAvailable) continue;
                if (JBossManager.processHasDied(proc)) break;
                Thread.sleep(sleep);
                timeout -= sleep;
                sleep = Math.max(sleep / 2L, 100L);
            }
            if (!serverAvailable) {
                this.destroyProcess();
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", this.configuration.getStartupTimeoutInSeconds()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not start container", e);
        }
    }

    private ManagementClient getManagementClient() {
        return this.client;
    }

    private void stopInternal() throws ContainerManagerException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new ContainerManagerException("Could not stop container", e);
        }
    }

    private static boolean processHasDied(Process process) {
        try {
            process.exitValue();
            return true;
        }
        catch (IllegalThreadStateException e) {
            return false;
        }
    }

    private void safeCloseClient() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            log.log(Level.WARNING, "Caught exception closing ModelControllerClient", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning() {
        Socket socket = null;
        try {
            socket = new Socket(this.configuration.getManagementAddress(), this.configuration.getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning() {
        throw new RuntimeException("The server is already running! Managed containers does not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server. Please stop server before running or change to another type of container.\n");
    }

    private int destroyProcess() {
        if (this.process == null) {
            return 0;
        }
        this.process.destroy();
        try {
            return this.process.waitFor();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private static class Authentication {
        public static String username = "";
        public static String password = "";

        private Authentication() {
        }

        public static CallbackHandler getCallbackHandler() {
            return new CallbackHandler();
        }

        public static class CallbackHandler
        implements javax.security.auth.callback.CallbackHandler {
            @Override
            public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                for (Callback current : callbacks) {
                    if (current instanceof NameCallback) {
                        NameCallback ncb = (NameCallback)current;
                        ncb.setName(username);
                        continue;
                    }
                    if (current instanceof PasswordCallback) {
                        PasswordCallback pcb = (PasswordCallback)current;
                        pcb.setPassword(password.toCharArray());
                        continue;
                    }
                    if (current instanceof RealmCallback) {
                        RealmCallback rcb = (RealmCallback)current;
                        rcb.setText(rcb.getDefaultText());
                        continue;
                    }
                    throw new UnsupportedCallbackException(current);
                }
            }
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = JBossManager.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = JBossManager.this.configuration.isOutputToConsole();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

