/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.File;

public class ManagedContainerConfiguration {
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String javaHome = System.getenv("JAVA_HOME");
    private String modulePath = System.getProperty("module.path");
    private String javaVmArguments = System.getProperty("jboss.options", "-Xmx512m -XX:MaxPermSize=128m");
    private String managementAddress;
    private int managementPort;
    private String username;
    private String password;
    private int startupTimeoutInSeconds = 60;
    private boolean outputToConsole = true;
    private String serverConfig = System.getProperty("jboss.server.config.file.name", "standalone.xml");
    private boolean allowConnectingToRunningServer = false;
    private boolean enableAssertions = true;

    public ManagedContainerConfiguration() {
        if (this.javaHome == null || this.javaHome.isEmpty()) {
            this.javaHome = System.getProperty("java.home");
        }
        this.managementAddress = "127.0.0.1";
        this.managementPort = 9999;
    }

    public void validate() throws IllegalStateException {
        File jbossHome = new File(this.jbossHome);
        if (!jbossHome.exists() || !jbossHome.isDirectory()) {
            throw new IllegalStateException("jbossHome '" + jbossHome.getAbsolutePath() + "' must exist!");
        }
        File javaHome = new File(this.javaHome);
        if (!javaHome.exists() || !jbossHome.isDirectory()) {
            throw new IllegalStateException("javaHome '" + javaHome.getAbsolutePath() + "' must exist!");
        }
        if (this.username != null && this.password == null) {
            throw new IllegalStateException("username has been set, but no password given");
        }
    }

    public String getManagementAddress() {
        return this.managementAddress;
    }

    public ManagedContainerConfiguration setManagementAddress(String host) {
        this.managementAddress = host;
        return this;
    }

    public int getManagementPort() {
        return this.managementPort;
    }

    public ManagedContainerConfiguration setManagementPort(int managementPort) {
        this.managementPort = managementPort;
        return this;
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public ManagedContainerConfiguration setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
        return this;
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public ManagedContainerConfiguration setJavaHome(String javaHome) {
        this.javaHome = javaHome;
        return this;
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public ManagedContainerConfiguration setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
        return this;
    }

    public ManagedContainerConfiguration setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        this.startupTimeoutInSeconds = startupTimeoutInSeconds;
        return this;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public ManagedContainerConfiguration setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
        return this;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public ManagedContainerConfiguration setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
        return this;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public ManagedContainerConfiguration setModulePath(String modulePath) {
        this.modulePath = modulePath;
        return this;
    }

    public boolean isAllowConnectingToRunningServer() {
        return this.allowConnectingToRunningServer;
    }

    public ManagedContainerConfiguration setAllowConnectingToRunningServer(boolean allowConnectingToRunningServer) {
        this.allowConnectingToRunningServer = allowConnectingToRunningServer;
        return this;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public ManagedContainerConfiguration setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
        return this;
    }

    public String getUsername() {
        return this.username;
    }

    public ManagedContainerConfiguration setUsername(String username) {
        if (username != null && username.length() > 0) {
            this.username = username;
        }
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ManagedContainerConfiguration setPassword(String password) {
        if (password != null && password.length() > 0) {
            this.password = password;
        }
        return this;
    }
}

