/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.IOException;
import java.net.URI;
import javax.management.remote.JMXConnector;
import javax.management.remote.JMXServiceURL;
import org.jboss.as.controller.ControlledProcessState;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;

public class ManagementClient {
    private static final String NAME = "name";
    private final String mgmtAddress;
    private final int mgmtPort;
    private final ModelControllerClient client;
    private URI webUri;
    private URI ejbUri;
    private ModelNode rootNode = null;
    private JMXConnector connector;

    public ManagementClient(ModelControllerClient client, String mgmtAddress, int managementPort) {
        if (client == null) {
            throw new IllegalArgumentException("Client must be specified");
        }
        this.client = client;
        this.mgmtAddress = mgmtAddress;
        this.mgmtPort = managementPort;
    }

    public ModelControllerClient getControllerClient() {
        return this.client;
    }

    public URI getWebUri() {
        if (this.webUri == null) {
            try {
                if (this.rootNode == null) {
                    this.readRootNode();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            String socketBinding = this.rootNode.get("subsystem").get("web").get("connector").get("http").get("socket-binding").asString();
            this.webUri = this.getBinding("http", socketBinding);
        }
        return this.webUri;
    }

    public boolean isServerInRunningState() {
        try {
            ModelNode op = Util.getEmptyOperation((String)"read-attribute", (ModelNode)PathAddress.EMPTY_ADDRESS.toModelNode());
            op.get(NAME).set("server-state");
            ModelNode rsp = this.client.execute(op);
            return "success".equals(rsp.get("outcome").asString()) && !ControlledProcessState.State.STARTING.toString().equals(rsp.get("result").asString()) && !ControlledProcessState.State.STOPPING.toString().equals(rsp.get("result").asString());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    public void close() {
        try {
            this.getControllerClient().close();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not close connection", e);
        }
        finally {
            if (this.connector != null) {
                try {
                    this.connector.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not close JMX connection", e);
                }
            }
        }
    }

    private void readRootNode() throws Exception {
        this.rootNode = this.readResource(new ModelNode());
    }

    private static ModelNode defined(ModelNode node, String message) {
        if (!node.isDefined()) {
            throw new IllegalStateException(message);
        }
        return node;
    }

    private URI getBinding(String protocol, String socketBinding) {
        try {
            String socketBindingGroupName = (String)this.rootNode.get("socket-binding-group").keys().iterator().next();
            ModelNode operation = new ModelNode();
            operation.get("address").get("socket-binding-group").set(socketBindingGroupName);
            operation.get("address").get("socket-binding").set(socketBinding);
            operation.get("operation").set("read-attribute");
            operation.get(NAME).set("bound-address");
            String ip = this.executeForResult(operation).asString();
            if (ip.contains(":") && ip.contains("%")) {
                ip = ip.split("%")[0];
            }
            ModelNode portOp = new ModelNode();
            portOp.get("address").get("socket-binding-group").set(socketBindingGroupName);
            portOp.get("address").get("socket-binding").set(socketBinding);
            portOp.get("operation").set("read-attribute");
            portOp.get(NAME).set("bound-port");
            int port = ManagementClient.defined(this.executeForResult(portOp), socketBindingGroupName + " -> " + socketBinding + " -> bound-port is undefined").asInt();
            return URI.create(protocol + "://" + NetworkUtils.formatPossibleIpv6Address(ip) + ":" + port);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ModelNode readResource(ModelNode address) throws Exception {
        ModelNode operation = new ModelNode();
        operation.get("operation").set("read-resource");
        operation.get("recursive").set("true");
        operation.get("address").set(address);
        return this.executeForResult(operation);
    }

    private ModelNode executeForResult(ModelNode operation) throws Exception {
        ModelNode result = this.client.execute(operation);
        this.checkSuccessful(result, operation);
        return result.get("result");
    }

    private void checkSuccessful(ModelNode result, ModelNode operation) throws UnSuccessfulOperationException {
        if (!"success".equals(result.get("outcome").asString())) {
            throw new UnSuccessfulOperationException(result.get("failure-description").toString());
        }
    }

    public JMXServiceURL getRemoteJMXURL() {
        try {
            return new JMXServiceURL("service:jmx:remoting-jmx://" + NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress) + ":" + this.mgmtPort);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create JMXServiceURL:" + this, e);
        }
    }

    public int getMgmtPort() {
        return this.mgmtPort;
    }

    public String getMgmtAddress() {
        return NetworkUtils.formatPossibleIpv6Address(this.mgmtAddress);
    }

    public URI getRemoteEjbURL() {
        if (this.ejbUri == null) {
            if (this.rootNode == null) {
                try {
                    this.readRootNode();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            String socketBinding = this.rootNode.get("subsystem").get("remoting").get("connector").get("remoting-connector").get("socket-binding").asString();
            this.ejbUri = this.getBinding("remote", socketBinding);
        }
        return this.ejbUri;
    }

    private static class NetworkUtils {
        public static String formatPossibleIpv6Address(String address) {
            if (address == null) {
                return address;
            }
            if (!address.contains(":")) {
                return address;
            }
            if (address.startsWith("[") && address.endsWith("]")) {
                return address;
            }
            return "[" + address + "]";
        }

        private NetworkUtils() {
        }
    }

    private static class UnSuccessfulOperationException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public UnSuccessfulOperationException(String message) {
            super(message);
        }
    }
}

