/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.spacelift;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.SystemUtils;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.CommandBuilder;
import org.arquillian.spacelift.process.impl.CommandTool;
import org.arquillian.spacelift.tool.Tool;

public class JBossCLI
extends Tool<Object, Void> {
    private Map<String, String> environment;
    String user;
    String password;
    File file;
    String controller;
    boolean connect = false;
    List<String> command = new ArrayList<String>();

    public JBossCLI() {
        this.environment = new HashMap<String, String>();
        this.environment.put("JBOSS_HOME", System.getenv("JBOSS_HOME"));
    }

    public JBossCLI environment(String key, String value) {
        if (key != null) {
            this.environment.put(key, value);
        }
        return this;
    }

    public JBossCLI environment(Map<String, String> environment) {
        if (environment != null) {
            environment.putAll(environment);
        }
        return this;
    }

    public JBossCLI user(String user) {
        this.user = user;
        return this;
    }

    public JBossCLI password(String password) {
        this.password = password;
        return this;
    }

    public JBossCLI file(String file) {
        this.file = new File(file);
        return this;
    }

    public JBossCLI file(File file) {
        this.file = file;
        return this;
    }

    public JBossCLI controller(String controller) {
        this.controller = controller;
        return this;
    }

    public JBossCLI connect() {
        this.connect = true;
        return this;
    }

    public JBossCLI cliCommand(String ... command) {
        this.command.addAll(Arrays.asList(command));
        return this;
    }

    protected Collection<String> aliases() {
        return Arrays.asList("jbosscli_binary");
    }

    protected Void process(Object input) throws Exception {
        CommandTool jbossCliTool = this.getJBossCliTool();
        if (this.controller != null) {
            jbossCliTool.parameter((CharSequence)("--controller=" + this.controller));
        }
        if (this.connect) {
            jbossCliTool.parameter((CharSequence)"--connect");
        }
        if (this.file != null) {
            jbossCliTool.parameter((CharSequence)("--file=" + this.file.getAbsolutePath()));
        }
        if (this.command.size() == 1) {
            jbossCliTool.parameter((CharSequence)("--command=" + this.command.get(0)));
        }
        if (this.command.size() > 1) {
            jbossCliTool.parameter((CharSequence)("--commands=" + this.getCommands()));
        }
        if (this.user != null) {
            jbossCliTool.parameter((CharSequence)("--user=" + this.user));
        }
        if (this.password != null) {
            jbossCliTool.parameter((CharSequence)("--password=" + this.password));
        }
        jbossCliTool.execute().await();
        return null;
    }

    private String getCommands() {
        StringBuilder sb = new StringBuilder();
        String delim = "";
        for (String command : this.command) {
            sb.append(delim).append(command);
            delim = ",";
        }
        return sb.toString();
    }

    private CommandTool getJBossCliTool() {
        if (SystemUtils.IS_OS_WINDOWS) {
            return ((CommandTool)Tasks.prepare(CommandTool.class)).command(new CommandBuilder((CharSequence)"cmd.exe")).parameters(new CharSequence[]{"/C", new File(this.environment.get("JBOSS_HOME"), "/bin/jboss-cli.bat").getAbsolutePath()}).addEnvironment(this.environment);
        }
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            return ((CommandTool)Tasks.prepare(CommandTool.class)).command(new CommandBuilder((CharSequence)new File(this.environment.get("JBOSS_HOME"), "/bin/jboss-cli.sh").getAbsolutePath())).addEnvironment(this.environment);
        }
        throw new IllegalStateException("Unrecognized operating system.");
    }
}

