/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.File;
import org.arquillian.spacelift.process.Command;
import org.arquillian.spacelift.process.CommandBuilder;
import org.jboss.aerogear.test.container.manager.JBossManagerConfiguration;

public class JBossCommandBuilder {
    public Command build(JBossManagerConfiguration configuration) throws Exception {
        this.validate(configuration);
        if (configuration.isDomain()) {
            return this.buildDomainCommand(configuration);
        }
        return this.buildStandaloneCommand(configuration);
    }

    private Command buildStandaloneCommand(JBossManagerConfiguration configuration) {
        CommandBuilder cb = new CommandBuilder((CharSequence)configuration.getJavaBin());
        cb.parameter((CharSequence)"-D[Standalone]");
        cb.splitToParameters((CharSequence)configuration.getJavaOpts());
        cb.parameter((CharSequence)("-Dorg.jboss.boot.log.file=" + configuration.getJBossLogDir() + "/server.log"));
        cb.parameter((CharSequence)("-Dlogging.configuration=file:" + configuration.getJBossConfigDir() + "/logging.properties"));
        if (new File(configuration.getJBossModuleDir() + "/bundles").exists()) {
            cb.parameter((CharSequence)("-Djboss.bundles.dir=" + configuration.getJBossModuleDir() + "/bundles"));
        }
        cb.parameters(new CharSequence[]{"-jar", configuration.getJBossHome() + "/jboss-modules.jar"});
        cb.parameters(new CharSequence[]{"-mp", configuration.getJBossModuleDir()});
        cb.parameters(new CharSequence[]{"-jaxpmodule", "javax.xml.jaxp-provider"});
        cb.parameters(new CharSequence[]{"org.jboss.as.standalone"});
        cb.parameter((CharSequence)("-Djboss.home.dir=" + configuration.getJBossHome()));
        cb.parameter((CharSequence)("-Djboss.server.base.dir=" + configuration.getJBossBaseDir()));
        cb.splitToParameters((CharSequence)configuration.getServerJavaOpts());
        return cb.build();
    }

    private Command buildDomainCommand(JBossManagerConfiguration configuration) {
        CommandBuilder cb = new CommandBuilder((CharSequence)configuration.getJavaBin());
        cb.parameters(new CharSequence[]{"-D[Process Controller]"});
        cb.splitToParameters((CharSequence)configuration.getProcessControllerJavaOpts());
        cb.parameter((CharSequence)("-Dorg.jboss.boot.log.file=" + configuration.getJBossLogDir() + "/process-controller.log"));
        cb.parameter((CharSequence)("-Dlogging.configuration=file:" + configuration.getJBossConfigDir() + "/logging.properties"));
        if (new File(configuration.getJBossModuleDir() + "/bundles").exists()) {
            cb.parameter((CharSequence)("-Djboss.bundles.dir=" + configuration.getJBossModuleDir() + "/bundles"));
        }
        cb.parameters(new CharSequence[]{"-jar", configuration.getJBossHome() + "/jboss-modules.jar"});
        cb.parameters(new CharSequence[]{"-mp", configuration.getJBossModuleDir()});
        cb.parameter((CharSequence)"org.jboss.as.process-controller");
        cb.parameters(new CharSequence[]{"-jboss-home", configuration.getJBossHome()});
        cb.parameters(new CharSequence[]{"-jvm", configuration.getJavaBin()});
        cb.parameters(new CharSequence[]{"-mp", configuration.getJBossModuleDir()});
        cb.parameter((CharSequence)"--");
        cb.parameter((CharSequence)("-Dorg.jboss.boot.log.file=" + configuration.getJBossLogDir() + "/host-controller.log"));
        cb.parameter((CharSequence)("-Dlogging.configuration=file:" + configuration.getJBossConfigDir() + "/logging.properties"));
        cb.splitToParameters((CharSequence)configuration.getHostControllerJavaOpts());
        cb.parameter((CharSequence)"--");
        cb.parameters(new CharSequence[]{"-default-jvm", configuration.getJavaBin()});
        return cb.build();
    }

    private void validate(JBossManagerConfiguration configuration) throws RuntimeException {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration set to JBossCommandBuilder is null.");
        }
        if (configuration.getJBossHome() == null) {
            throw new IllegalStateException("JBOSS_HOME is set to null for JBossCommandBuilder");
        }
    }
}

