/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import org.arquillian.spacelift.execution.CountDownWatch;
import org.arquillian.spacelift.execution.Tasks;
import org.arquillian.spacelift.process.Command;
import org.jboss.aerogear.test.container.manager.JBossCommandBuilder;
import org.jboss.aerogear.test.container.manager.JBossManagerConfiguration;
import org.jboss.aerogear.test.container.manager.JBossStartChecker;
import org.jboss.aerogear.test.container.manager.api.ContainerManager;
import org.jboss.aerogear.test.container.manager.api.ContainerManagerException;

public class JBossManager
implements ContainerManager {
    private static final Logger logger = Logger.getLogger(JBossManager.class.getName());
    private Thread shutdownThread;
    private Process process;
    private final JBossManagerConfiguration configuration;

    public JBossManager() {
        this(new JBossManagerConfiguration());
    }

    public JBossManager(JBossManagerConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Provided configuration to JBossManager is a null object!");
        }
        this.configuration = configuration;
    }

    @Override
    public void start() throws ContainerManagerException {
        try {
            Command command = new JBossCommandBuilder().build(this.configuration);
            logger.info("Starting container with: " + command.toString());
            ProcessBuilder processBuilder = new ProcessBuilder(command.getFullCommand());
            processBuilder.redirectErrorStream(true);
            this.process = processBuilder.start();
            new Thread(new ConsoleConsumer()).start();
            final Process proc = this.process;
            this.shutdownThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    if (proc != null) {
                        proc.destroy();
                        try {
                            proc.waitFor();
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            });
            Runtime.getRuntime().addShutdownHook(this.shutdownThread);
            ((JBossStartChecker)Tasks.chain((Object)this.configuration, JBossStartChecker.class)).execute().until(new CountDownWatch((long)this.configuration.getStartupTimeoutInSeconds(), TimeUnit.SECONDS), JBossStartChecker.jbossStartedCondition);
        }
        catch (Exception e) {
            throw new ContainerManagerException("Could not start container", e);
        }
    }

    @Override
    public void stop() throws ContainerManagerException {
        if (this.shutdownThread != null) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
            this.shutdownThread = null;
        }
        try {
            if (this.process != null) {
                this.process.destroy();
                this.process.waitFor();
                this.process = null;
            }
        }
        catch (Exception e) {
            throw new ContainerManagerException("Could not stop container", e);
        }
    }

    private class ConsoleConsumer
    implements Runnable {
        private ConsoleConsumer() {
        }

        @Override
        public void run() {
            InputStream stream = JBossManager.this.process.getInputStream();
            BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
            boolean writeOutput = JBossManager.this.configuration.isOutputToConsole();
            String line = null;
            try {
                while ((line = reader.readLine()) != null) {
                    if (!writeOutput) continue;
                    System.out.println(line);
                }
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }
}

