/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import org.arquillian.spacelift.execution.ExecutionCondition;
import org.arquillian.spacelift.execution.ExecutionException;
import org.arquillian.spacelift.execution.Task;
import org.arquillian.spacelift.execution.Tasks;
import org.jboss.aerogear.test.container.manager.JBossManagerConfiguration;
import org.jboss.aerogear.test.container.manager.check.DomainStartedCheckTask;
import org.jboss.aerogear.test.container.manager.check.ServerInDomainStartCheckTask;
import org.jboss.aerogear.test.container.manager.check.StandaloneStartedCheckTask;

class JBossStartChecker
extends Task<JBossManagerConfiguration, Boolean> {
    public static final ExecutionCondition<Boolean> jbossStartedCondition = new JBossStartedCondition();

    JBossStartChecker() {
    }

    protected Boolean process(JBossManagerConfiguration configuration) throws Exception {
        if (configuration == null) {
            throw new IllegalStateException("configuration is null object!");
        }
        configuration.validate();
        if (configuration.isDomain()) {
            return this.startDomainCheck(configuration);
        }
        return this.startStandaloneCheck(configuration);
    }

    private Boolean startStandaloneCheck(JBossManagerConfiguration configuration) {
        return (Boolean)((StandaloneStartedCheckTask)Tasks.chain((Object)configuration, StandaloneStartedCheckTask.class)).execute().await();
    }

    private Boolean startDomainCheck(JBossManagerConfiguration configuration) {
        boolean domainStarted = (Boolean)((DomainStartedCheckTask)Tasks.prepare(DomainStartedCheckTask.class)).configuration(configuration).execute().await();
        if (!domainStarted) {
            return false;
        }
        for (String domainServer : configuration.getDomainServers()) {
            boolean domainServerStarted = (Boolean)((ServerInDomainStartCheckTask)Tasks.chain((Object)domainServer, ServerInDomainStartCheckTask.class)).configuration(configuration).execute().await();
            if (domainServerStarted) continue;
            return false;
        }
        return true;
    }

    private static final class JBossStartedCondition
    implements ExecutionCondition<Boolean> {
        private JBossStartedCondition() {
        }

        public boolean satisfiedBy(Boolean started) throws ExecutionException {
            return started;
        }
    }
}

