/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager.configuration;

import org.arquillian.spacelift.Spacelift;
import org.jboss.aerogear.test.container.manager.JBossManagerConfiguration;
import org.jboss.aerogear.test.container.manager.configuration.ContainerType;
import org.jboss.aerogear.test.container.manager.configuration.JavaServerOptionCapabilityCheck;

public class ContainerJavaOptsConfiguration {
    private static final String SPACE = " ";

    public static final String getContainerJavaOpts(JBossManagerConfiguration configuration) {
        ContainerType type = configuration.getContainerType();
        if (type == null) {
            throw new IllegalStateException("Type of container to get Java options for is a null object!");
        }
        switch (type) {
            case AS7: {
                return ContainerJavaOptsConfiguration.getAS7JavaOpts(configuration);
            }
            case EAP: {
                return ContainerJavaOptsConfiguration.getEAPJavaOpts(configuration);
            }
            case WILDFLY: {
                return ContainerJavaOptsConfiguration.getWildFlyJavaOpts(configuration);
            }
        }
        throw new IllegalStateException("Unable to get Java options for container of type " + type.name());
    }

    private static String getWildFlyJavaOpts(JBossManagerConfiguration configuration) {
        StringBuilder sb = new StringBuilder();
        if (!configuration.isDomain()) {
            sb.append("-server").append(SPACE);
        } else if (((Boolean)((JavaServerOptionCapabilityCheck)Spacelift.task((Object)configuration, JavaServerOptionCapabilityCheck.class)).execute().await()).booleanValue()) {
            sb.append("-server").append(SPACE);
        }
        sb.append("-Xms64m").append(SPACE).append("-Xmx512m").append(SPACE).append("-XX:MaxPermSize=256m").append(SPACE).append("-Djava.net.preferIPv4Stack=true").append(SPACE).append("-Djboss.modules.system.pkgs=org.jboss.byteman").append(SPACE).append("-Djava.awt.headless=true");
        if (configuration.isDomain()) {
            sb.append("-Djboss.domain.default.config=" + configuration.getDomainConfig()).append(SPACE).append("-Djboss.host.default.config=" + configuration.getHostConfig());
        } else {
            sb.append("-Djboss.server.default.config=" + configuration.getStandaloneConfig());
        }
        return sb.toString();
    }

    private static String getEAPJavaOpts(JBossManagerConfiguration configuration) {
        StringBuilder sb = new StringBuilder();
        if (!configuration.isDomain()) {
            sb.append("-server").append(SPACE).append("-XX:+UseCompressedOops").append(SPACE).append("-verbose:gc").append(SPACE).append("-Xloggc:\"" + configuration.getJBossLogDir() + "/gc.log\"").append(SPACE).append("-XX:+PrintGCDetails").append(SPACE).append("-XX:+PrintGCDateStamps").append(SPACE).append("-XX:+UseGCLogFileRotation").append(SPACE).append("-XX:NumberOfGCLogFiles=5").append(SPACE).append("-XX:GCLogFileSize=3M").append(SPACE).append("-XX:-TraceClassUnloading").append(SPACE).append("-Xms1303m").append(SPACE).append("-Xmx1303m").append(SPACE);
        } else {
            if (((Boolean)((JavaServerOptionCapabilityCheck)Spacelift.task((Object)configuration, JavaServerOptionCapabilityCheck.class)).execute().await()).booleanValue()) {
                sb.append("-server").append(SPACE);
            }
            sb.append("-Xms64m").append(SPACE).append("-Xmx512m").append(SPACE);
        }
        sb.append("-XX:MaxPermSize=256m").append(SPACE).append("-Djava.net.preferIPv4Stack=true").append(SPACE).append("-Djboss.modules.system.pkgs=org.jboss.byteman").append(SPACE).append("-Djava.awt.headless=true").append(SPACE).append("-Djboss.modules.policy-permissions=true").append(SPACE);
        if (configuration.isDomain()) {
            sb.append("-Djboss.domain.default.config=" + configuration.getDomainConfig()).append(SPACE).append("-Djboss.host.default.config=" + configuration.getHostConfig());
        } else {
            sb.append("-Djboss.server.default.config=" + configuration.getStandaloneConfig());
        }
        return sb.toString();
    }

    private static String getAS7JavaOpts(JBossManagerConfiguration configuration) {
        StringBuilder sb = new StringBuilder();
        if (!configuration.isDomain()) {
            sb.append("-server").append(SPACE).append("-XX:+UseCompressedOops").append(SPACE).append("-XX:+TieredCompilation").append(SPACE);
        } else if (((Boolean)((JavaServerOptionCapabilityCheck)Spacelift.task((Object)configuration, JavaServerOptionCapabilityCheck.class)).execute().await()).booleanValue()) {
            sb.append("-server").append(SPACE);
        }
        sb.append("-Xms64m").append(SPACE).append("-Xmx512m").append(SPACE).append("-XX:MaxPermSize=256m").append(SPACE).append("-Djava.net.preferIPv4Stack=true").append(SPACE).append("-Dorg.jboss.resolver.warning=true").append(SPACE).append("-Dsun.rmi.dgc.client.gcInterval=3600000").append(SPACE).append("-Dsun.rmi.dgc.server.gcInterval=3600000").append(SPACE).append("-Djboss.modules.system.pkgs=org.jboss.byteman").append(SPACE).append("-Djava.awt.headless=true").append(SPACE);
        if (configuration.isDomain()) {
            sb.append("-Djboss.domain.default.config=" + configuration.getDomainConfig()).append(SPACE).append("-Djboss.host.default.config=" + configuration.getHostConfig());
        } else {
            sb.append("-Djboss.server.default.config=" + configuration.getStandaloneConfig());
        }
        return sb.toString();
    }
}

