/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.test.container.manager;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.jboss.aerogear.test.container.manager.configuration.ContainerJavaOptsConfiguration;
import org.jboss.aerogear.test.container.manager.configuration.ContainerType;

public class JBossManagerConfiguration {
    private static final String[] DEFAULT_DOMAIN_SERVERS = new String[]{"server-one", "server-two"};
    private String javaHome = System.getProperty("java.home");
    private String jbossHome = System.getProperty("jboss.home");
    private String javaOpts = null;
    private String processControllerJavaOpts = null;
    private String hostControllerJavaOpts = null;
    private String serverJavaOpts = "";
    private int startupTimeoutInSeconds = 120;
    private boolean outputToConsole = true;
    private String user;
    private String password;
    private ContainerType containerType = ContainerType.WILDFLY;
    private String domainConfig = "domain.xml";
    private String hostConfig = "host.xml";
    private String standaloneConfig = "standalone.xml";
    private boolean domain;
    private String serverGroup = System.getProperty("server.group", "main-server-group");
    private long domainStartTimeout = 60L;
    private List<String> domainServers = Arrays.asList(DEFAULT_DOMAIN_SERVERS);
    private String domainMasterHostName = "master";

    public JBossManagerConfiguration() {
        if (this.javaHome == null || this.javaHome.length() == 0) {
            this.javaHome = System.getenv("JAVA_HOME");
        }
        if (this.javaHome != null) {
            this.javaHome.trim();
        }
        if (this.jbossHome == null || this.jbossHome.length() == 0) {
            this.jbossHome = System.getenv("JBOSS_HOME");
        }
        if (this.jbossHome != null) {
            this.jbossHome.trim();
        }
    }

    public void validate() throws IllegalStateException {
        if (this.getJBossHome() != null) {
            File jbossHome = new File(this.getJBossHome());
            if (!jbossHome.exists() || !jbossHome.isDirectory()) {
                throw new IllegalStateException("jbossHome '" + this.getJBossHome() + "' must exist!");
            }
        } else {
            throw new IllegalStateException("Could not determine the value of JBoss home directory.");
        }
        if (!new File(this.getJBossBaseDir()).exists()) {
            throw new IllegalStateException("Could not determine the value of JBoss base directory.");
        }
        if (!new File(this.getJBossConfigDir()).exists()) {
            throw new IllegalStateException("Could not determine the value of JBoss configuration directory.");
        }
        if (this.javaHome != null) {
            File javaHome = new File(this.javaHome);
            if (!javaHome.exists() || !javaHome.isDirectory()) {
                throw new IllegalStateException("javaHome '" + javaHome.getAbsolutePath() + "' must exist!");
            }
        } else {
            throw new IllegalStateException("Could not determine the value of Java home directory.");
        }
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public JBossManagerConfiguration setJavaHome(String javaHome) {
        if (javaHome != null && new File(javaHome).isDirectory()) {
            this.javaHome = javaHome;
        }
        return this;
    }

    public String getJavaBin() {
        String javaExec = null;
        if (this.getJavaHome() != null) {
            javaExec = this.getJavaHome() + File.separatorChar + "bin" + File.separatorChar + "java";
            if (this.getJavaHome().contains(" ")) {
                javaExec = "\"" + javaExec + "\"";
            }
        } else {
            javaExec = "java";
        }
        return javaExec;
    }

    public String getJBossHome() {
        String resolvedJbossHome = null;
        resolvedJbossHome = this.jbossHome.contains(" ") ? "\"" + this.jbossHome + "\"" : this.jbossHome;
        return new File(resolvedJbossHome).getAbsolutePath();
    }

    public JBossManagerConfiguration setJBossHome(String jbossHome) {
        if (jbossHome != null && new File(jbossHome).isDirectory()) {
            this.jbossHome = jbossHome.trim();
        }
        return this;
    }

    public String getJBossBaseDir() {
        if (this.isDomain()) {
            return this.getJBossHome() + "/domain";
        }
        return this.getJBossHome() + "/standalone";
    }

    public String getJBossLogDir() {
        return this.getJBossBaseDir() + "/log";
    }

    public String getJBossConfigDir() {
        return this.getJBossBaseDir() + "/configuration";
    }

    public String getJBossModuleDir() {
        return this.getJBossHome() + "/modules";
    }

    public String getJavaOpts() {
        if (this.javaOpts == null) {
            return ContainerJavaOptsConfiguration.getContainerJavaOpts(this);
        }
        return this.javaOpts;
    }

    public JBossManagerConfiguration setJavaOpts(String javaOpts) {
        if (javaOpts != null) {
            this.javaOpts = javaOpts;
        }
        return this;
    }

    public int getStartupTimeoutInSeconds() {
        return this.startupTimeoutInSeconds;
    }

    public JBossManagerConfiguration setStartupTimeoutInSeconds(int startupTimeoutInSeconds) {
        if (startupTimeoutInSeconds > 0) {
            this.startupTimeoutInSeconds = startupTimeoutInSeconds;
        }
        return this;
    }

    public JBossManagerConfiguration setOutputToConsole(boolean outputToConsole) {
        this.outputToConsole = outputToConsole;
        return this;
    }

    public boolean isOutputToConsole() {
        return this.outputToConsole;
    }

    public String getProcessControllerJavaOpts() {
        if (this.processControllerJavaOpts == null) {
            return ContainerJavaOptsConfiguration.getContainerJavaOpts(this);
        }
        return this.processControllerJavaOpts;
    }

    public JBossManagerConfiguration setProcessControllerJavaOpts(String processControllerJavaOpts) {
        if (processControllerJavaOpts != null) {
            this.processControllerJavaOpts = processControllerJavaOpts;
        }
        return this;
    }

    public String getHostControllerJavaOpts() {
        if (this.hostControllerJavaOpts == null) {
            return ContainerJavaOptsConfiguration.getContainerJavaOpts(this);
        }
        return this.hostControllerJavaOpts;
    }

    public JBossManagerConfiguration setHostControllerJavaOpts(String hostControllerJavaOpts) {
        if (hostControllerJavaOpts != null) {
            this.hostControllerJavaOpts = hostControllerJavaOpts;
        }
        return this;
    }

    public String getServerJavaOpts() {
        return this.serverJavaOpts;
    }

    public JBossManagerConfiguration setServerJavaOpts(String serverJavaOpts) {
        if (serverJavaOpts != null) {
            this.serverJavaOpts = serverJavaOpts;
        }
        return this;
    }

    public JBossManagerConfiguration setUser(String user) {
        if (user != null) {
            this.user = user;
        }
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public JBossManagerConfiguration setPassword(String password) {
        if (password != null) {
            this.password = password;
        }
        return this;
    }

    public String getPassword() {
        return this.password;
    }

    public ContainerType getContainerType() {
        return this.containerType;
    }

    public JBossManagerConfiguration setContainerType(ContainerType containerType) {
        if (containerType != null) {
            this.containerType = containerType;
        }
        return this;
    }

    public String getDomainConfig() {
        return this.domainConfig;
    }

    public JBossManagerConfiguration setDomainConfig(String domainConfig) {
        if (domainConfig != null && domainConfig.length() != 0) {
            this.domainConfig = domainConfig;
        }
        return this;
    }

    public String getHostConfig() {
        return this.hostConfig;
    }

    public JBossManagerConfiguration setHostConfig(String hostConfig) {
        if (hostConfig != null && hostConfig.length() != 0) {
            this.hostConfig = hostConfig;
        }
        return this;
    }

    public String getStandaloneConfig() {
        return this.standaloneConfig;
    }

    public JBossManagerConfiguration setStandaloneConfig(String standaloneConfig) {
        if (standaloneConfig != null && standaloneConfig.length() != 0) {
            this.standaloneConfig = standaloneConfig;
        }
        return this;
    }

    public boolean isDomain() {
        return this.domain;
    }

    public JBossManagerConfiguration domain() {
        this.domain = true;
        return this;
    }

    public String getServerGroup() {
        return this.serverGroup;
    }

    public JBossManagerConfiguration setServerGroup(String serverGroup) {
        if (serverGroup != null && serverGroup.length() != 0) {
            this.serverGroup = serverGroup;
        }
        return this;
    }

    public JBossManagerConfiguration setDomainStartTimeout(long domainStartTimeout) {
        if (domainStartTimeout > 0L) {
            this.domainStartTimeout = domainStartTimeout;
        }
        return this;
    }

    public long getDomainStartTimeout() {
        return this.domainStartTimeout;
    }

    public JBossManagerConfiguration setDomainServers(String domainServer, String ... domainServers) {
        if (domainServer != null && domainServer.length() != 0) {
            this.domainServers.clear();
            this.domainServers.add(domainServer);
        }
        for (String domainServerArg : domainServers) {
            if (domainServer == null || domainServer.length() == 0) continue;
            this.domainServers.add(domainServerArg);
        }
        return this;
    }

    public JBossManagerConfiguration setDomainServers(List<String> domainServers) {
        if (domainServers != null) {
            this.domainServers.clear();
            for (String domainServer : domainServers) {
                if (domainServer == null || domainServer.length() == 0) continue;
                this.domainServers.add(domainServer);
            }
        }
        return this;
    }

    public List<String> getDomainServers() {
        return this.domainServers;
    }

    public JBossManagerConfiguration setDomainMasterHostName(String domainMasterHostName) {
        if (domainMasterHostName != null) {
            this.domainMasterHostName = domainMasterHostName;
        }
        return this;
    }

    public String getDomainMasterHostName() {
        return this.domainMasterHostName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("jboss dir\t").append(this.getJBossHome()).append("\n").append("base dir\t").append(this.getJBossBaseDir()).append("\n").append("config dir\t").append(this.getJBossConfigDir()).append("\n").append("log dir\t\t").append(this.getJBossLogDir()).append("\n").append("module dir\t").append(this.getJBossModuleDir()).append("\n");
        return sb.toString();
    }
}

